/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.FindAllRoleAdministrationAuthorizationsCommand;
import br.com.petrobras.security.command.management.authorization.FindAllRoleAdministrationAuthorizationsOfRoleCommand;
import br.com.petrobras.security.command.management.authorization.GrantRoleAdministrationAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.RevokeRoleAdminAuthFromRoleByUidCommand;
import br.com.petrobras.security.command.management.authorization.RevokeRoleAdministrationAuthorizationFromRoleCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IRoleAdministrationAuthorizationManager;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.access.RoleAdministrationAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleAdministrationAuthorizationManagerCoreImpl
implements IRoleAdministrationAuthorizationManager {
    public List<RoleAdministrationAuthorization> findAllOfAdministratorRole(Role administratorRole) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)administratorRole);
        return this.findAllOfAdministratorRole(administratorRole.getId());
    }

    public List<RoleAdministrationAuthorization> findAllOfAdministratorRole(String administratorRoleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllRoleAdministrationAuthorizationsOfRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleAdministrationAuthorizationsOfRoleCommand();
        cmd.setAdministratorRoleIdArg(administratorRoleId);
        return (List)cmd.execute();
    }

    public void grant(Role administratorRole, Role administeredRole) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)administratorRole);
        Validator.throwInvalidArgumentExceptionIfNull((Object)administeredRole);
        this.grant(administratorRole.getId(), administeredRole.getId());
    }

    public void grant(String administratorRoleId, String administeredRoleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantRoleAdministrationAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAdministrationAuthorizationToRoleCommand();
        cmd.setAdministratorRoleIdArg(administratorRoleId);
        cmd.setAdministeredRoleIdArg(administeredRoleId);
        cmd.execute();
    }

    public void revoke(Role administratorRole, Role administeredRole) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)administratorRole);
        Validator.throwInvalidArgumentExceptionIfNull((Object)administeredRole);
        this.revoke(administratorRole.getId(), administeredRole.getId());
    }

    public void revoke(String administratorRoleId, String administeredRoleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeRoleAdministrationAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeRoleAdministrationAuthorizationFromRoleCommand();
        cmd.setAdministratorRoleIdArg(administratorRoleId);
        cmd.setAdministeredRoleIdArg(administeredRoleId);
        cmd.execute();
    }

    public List<RoleAdministrationAuthorization> findAll() throws PermissionDeniedException, SecurityException {
        FindAllRoleAdministrationAuthorizationsCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleAdministrationAuthorizationsCommand();
        return (List)cmd.execute();
    }

    public void revoke(Long roleAdministrationAuthorizationUid) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        RevokeRoleAdminAuthFromRoleByUidCommand cmd = ICommandIdentifier.getInstance().getRevokeRoleAdminAuthFromRoleByUidCommand();
        cmd.setRoleAdministrationAuthorizationUidArg(roleAdministrationAuthorizationUid);
        cmd.execute();
    }
}

