/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.basic;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.basic.application.FindAllApplicationsCommand;
import br.com.petrobras.security.command.management.basic.application.FindAllApplicationsInEnvironmentCommand;
import br.com.petrobras.security.command.management.basic.application.FindApplicationByIdCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.management.basic.IApplicationManager;
import br.com.petrobras.security.model.Application;
import java.util.List;

public class ApplicationManagerCoreImpl
implements IApplicationManager {
    public Application find(String applicationId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindApplicationByIdCommand cmd = ICommandIdentifier.getInstance().getFindApplicationByIdCommand();
        cmd.setApplicationIdArg(applicationId);
        return (Application)cmd.execute();
    }

    public List<Application> findAll() throws PermissionDeniedException, SecurityException {
        FindAllApplicationsCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationsCommand();
        return (List)cmd.execute();
    }

    public List<Application> findAllInCurrentConnectedEnvironment() throws PermissionDeniedException, SecurityException {
        FindAllApplicationsInEnvironmentCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationsInEnvironmentCommand();
        return (List)cmd.execute();
    }

    public List<Application> findAllInEnvironment(String regionalId, String environmentId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllApplicationsInEnvironmentCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationsInEnvironmentCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        return (List)cmd.execute();
    }
}

