/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.basic;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.basic.area.FindAllAreasCommand;
import br.com.petrobras.security.command.management.basic.area.FindAreaByIdCommand;
import br.com.petrobras.security.command.management.basic.area.FindAreasByIdsCommand;
import br.com.petrobras.security.command.management.basic.area.RemoveAreaCommand;
import br.com.petrobras.security.command.management.basic.area.SaveAreaCommand;
import br.com.petrobras.security.command.management.basic.area.UpdateAreaCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.basic.IAreaManager;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class AreaManagerCoreImpl
implements IAreaManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public Area find(String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAreaByIdCommand cmd = ICommandIdentifier.getInstance().getFindAreaByIdCommand();
        cmd.setAreaIdArg(areaId);
        return (Area)cmd.execute();
    }

    public List<Area> find(List<String> areaIds) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAreasByIdsCommand cmd = ICommandIdentifier.getInstance().getFindAreasByIdCommand();
        cmd.setAreaIdsArg(areaIds);
        return (List)cmd.execute();
    }

    public List<Area> findAll() throws PermissionDeniedException, SecurityException {
        FindAllAreasCommand cmd = ICommandIdentifier.getInstance().getFindAllAreasCommand();
        return (List)cmd.execute();
    }

    public void save(Area area) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, InvalidOperationException, SecurityException {
        SaveAreaCommand cmd = ICommandIdentifier.getInstance().getSaveAreaCommand();
        cmd.setAreaArg(area);
        cmd.execute();
    }

    public void update(String oldAreaId, Area area) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateAreaCommand cmd = ICommandIdentifier.getInstance().getUpdateAreaCommand();
        cmd.setOldAreaId(oldAreaId);
        cmd.setAreaArg(area);
        cmd.execute();
    }

    public void update(Area area) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateAreaCommand cmd = ICommandIdentifier.getInstance().getUpdateAreaCommand();
        cmd.setAreaArg(area);
        cmd.execute();
    }

    public void remove(Area area) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.remove(area.getId());
    }

    public void remove(String areaId) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        RemoveAreaCommand cmd = ICommandIdentifier.getInstance().getRemoveAreaCommand();
        cmd.setAreaIdArg(areaId);
        cmd.execute();
    }
}

