/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.inactivation;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.inactivation.user.ActivateUserCommand;
import br.com.petrobras.security.command.management.inactivation.user.AddInactivationToUserCommand;
import br.com.petrobras.security.command.management.inactivation.user.FindAllInactivatedUsersCommand;
import br.com.petrobras.security.command.management.inactivation.user.FindAllInactivationsOfUserCommand;
import br.com.petrobras.security.command.management.inactivation.user.FindAllUserInactivationsCommand;
import br.com.petrobras.security.command.management.inactivation.user.FindUserInactivationByUidCommand;
import br.com.petrobras.security.command.management.inactivation.user.RemoveUserInactivationCommand;
import br.com.petrobras.security.command.management.inactivation.user.UpdateUserInactivationCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.exception.TranslationNotFoundException;
import br.com.petrobras.security.management.inactivation.IUserInactivationManager;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.i18n.I18nString;
import br.com.petrobras.security.model.inactivation.UserInactivation;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class UserInactivationManagerCoreImpl
implements IUserInactivationManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public void addInactivationToUser(User user, I18nString reason) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.addInactivationToUser(user.getLogin(), reason, null);
    }

    public void addInactivationToUser(User user, I18nString reason, Expiration expiration) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.addInactivationToUser(user.getLogin(), reason, expiration);
    }

    public void addInactivationToUser(String userLogin, I18nString reason) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        this.addInactivationToUser(userLogin, reason, null);
    }

    public void addInactivationToUser(String userLogin, I18nString reason, Expiration expiration) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        AddInactivationToUserCommand cmd = ICommandIdentifier.getInstance().getInactivateUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setReasonArg(reason);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void updateInactivation(UserInactivation userInactivation) throws PermissionDeniedException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        UpdateUserInactivationCommand cmd = ICommandIdentifier.getInstance().getUpdateInactivationCommand();
        cmd.setUserInactivationArg(userInactivation);
        cmd.execute();
    }

    public void activate(User user, I18nString reason) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.activate(user.getLogin(), reason, null);
    }

    public void activate(String userLogin, I18nString reason) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, SecurityException {
        this.activate(userLogin, reason, null);
    }

    public void activate(String userLogin, I18nString reason, Expiration expiration) throws PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, SecurityException {
        ActivateUserCommand cmd = ICommandIdentifier.getInstance().getActivateUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setReasonArg(reason);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void removeInactivation(UserInactivation userInactivation, I18nString reason) throws PermissionDeniedException, ConstraintViolationException, InvalidArgumentException, TranslationNotFoundException, InvalidOperationException, SecurityException {
        RemoveUserInactivationCommand cmd = ICommandIdentifier.getInstance().getRemoveUserInactivationCommand();
        cmd.setUserInactivationArg(userInactivation);
        cmd.setReasonArg(reason);
        cmd.execute();
    }

    public List<UserInactivation> findAll() throws PermissionDeniedException, SecurityException {
        FindAllUserInactivationsCommand cmd = ICommandIdentifier.getInstance().getFindAllUserInactivationsCommand();
        return (List)cmd.execute();
    }

    public List<UserInactivation> findAllOfLoggedUser() throws InvalidOperationException, PermissionDeniedException, SecurityException {
        FindAllInactivationsOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAllInactivationsOfUserCommand();
        return (List)cmd.execute();
    }

    public List<UserInactivation> findAllOfUser(String userLogin) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllInactivationsOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAllInactivationsOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public List<UserInactivation> findAllOfUser(User user) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findAllOfUser(user.getLogin());
    }

    public List<User> findAllInactivatedUsers() throws PermissionDeniedException, SecurityException {
        FindAllInactivatedUsersCommand cmd = ICommandIdentifier.getInstance().getFindAllInactivatedUsersCommand();
        return (List)cmd.execute();
    }

    public UserInactivation find(Long userInactivationUid) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindUserInactivationByUidCommand cmd = ICommandIdentifier.getInstance().getFindUserInactivationByUidCommand();
        cmd.setUserInactivationUidArg(userInactivationUid);
        return (UserInactivation)cmd.execute();
    }
}

