/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.SimpleElementValue;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BIPUSH;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.ConstantPushInstruction;
import org.aspectj.apache.bcel.generic.INSTANCEOF;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LDC;
import org.aspectj.apache.bcel.generic.LineNumberTag;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.SIPUSH;
import org.aspectj.apache.bcel.generic.SWITCH;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.TargetLostException;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.BcelVar;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyMethodGen;

public class Utility {
    private static Hashtable validBoxing = new Hashtable();
    public static int testingParseCounter;

    private Utility() {
    }

    public static String beautifyLocation(ISourceLocation isl) {
        StringBuffer nice = new StringBuffer();
        if (isl == null || isl.getSourceFile() == null || isl.getSourceFile().getName().indexOf("no debug info available") != -1) {
            nice.append("no debug info available");
        } else {
            int takeFrom = isl.getSourceFile().getPath().lastIndexOf(47);
            if (takeFrom == -1) {
                takeFrom = isl.getSourceFile().getPath().lastIndexOf(92);
            }
            nice.append(isl.getSourceFile().getPath().substring(takeFrom + 1));
            if (isl.getLine() != 0) {
                nice.append(":").append(isl.getLine());
            }
        }
        return nice.toString();
    }

    public static Instruction createSuperInvoke(InstructionFactory fact, BcelWorld world, Member signature) {
        if (signature.isInterface()) {
            throw new RuntimeException("bad");
        }
        if (signature.isPrivate() || signature.getName().equals("<init>")) {
            throw new RuntimeException("unimplemented, possibly bad");
        }
        if (signature.isStatic()) {
            throw new RuntimeException("bad");
        }
        short kind = 183;
        return fact.createInvoke(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), BcelWorld.makeBcelTypes(signature.getParameterTypes()), kind);
    }

    public static Instruction createInvoke(InstructionFactory fact, BcelWorld world, Member signature) {
        short kind = signature.isInterface() ? (short)185 : (signature.isStatic() ? (short)184 : (signature.isPrivate() || signature.getName().equals("<init>") ? (short)183 : 182));
        UnresolvedType targetType = signature.getDeclaringType();
        if (targetType.isParameterizedType()) {
            targetType = targetType.resolve(world).getGenericType();
        }
        return fact.createInvoke(targetType.getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), BcelWorld.makeBcelTypes(signature.getParameterTypes()), kind);
    }

    public static Instruction createGet(InstructionFactory fact, Member signature) {
        short kind = signature.isStatic() ? (short)178 : 180;
        return fact.createFieldAccess(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), kind);
    }

    public static Instruction createGetOn(InstructionFactory fact, Member signature, UnresolvedType declaringType) {
        short kind = signature.isStatic() ? (short)178 : 180;
        return fact.createFieldAccess(declaringType.getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), kind);
    }

    public static Instruction createSet(InstructionFactory fact, Member signature) {
        short kind = signature.isStatic() ? (short)179 : 181;
        return fact.createFieldAccess(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), kind);
    }

    public static Instruction createInvoke(InstructionFactory fact, JavaClass declaringClass, Method newMethod) {
        short kind = newMethod.isInterface() ? (short)185 : (newMethod.isStatic() ? (short)184 : (newMethod.isPrivate() || newMethod.getName().equals("<init>") ? (short)183 : 182));
        return fact.createInvoke(declaringClass.getClassName(), newMethod.getName(), Type.getReturnType(newMethod.getSignature()), Type.getArgumentTypes(newMethod.getSignature()), kind);
    }

    public static byte[] stringToUTF(String s) {
        try {
            ByteArrayOutputStream out0 = new ByteArrayOutputStream();
            DataOutputStream out1 = new DataOutputStream(out0);
            out1.writeUTF(s);
            return out0.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("sanity check");
        }
    }

    public static Instruction createInstanceof(InstructionFactory fact, ReferenceType t) {
        int cpoolEntry = t instanceof ArrayType ? fact.getConstantPool().addArrayClass((ArrayType)t) : fact.getConstantPool().addClass((ObjectType)t);
        return new INSTANCEOF(cpoolEntry);
    }

    public static Instruction createInvoke(InstructionFactory fact, LazyMethodGen m) {
        short kind = m.getEnclosingClass().isInterface() ? (short)185 : (m.isStatic() ? (short)184 : (m.isPrivate() || m.getName().equals("<init>") ? (short)183 : 182));
        return fact.createInvoke(m.getClassName(), m.getName(), m.getReturnType(), m.getArgumentTypes(), kind);
    }

    public static Instruction createInvoke(InstructionFactory fact, short kind, Member member) {
        return fact.createInvoke(member.getDeclaringType().getName(), member.getName(), BcelWorld.makeBcelType(member.getReturnType()), BcelWorld.makeBcelTypes(member.getParameterTypes()), kind);
    }

    public static String[] makeArgNames(int n) {
        String[] ret = new String[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = "arg" + i;
        }
        return ret;
    }

    public static void appendConversion(InstructionList il, InstructionFactory fact, ResolvedType fromType, ResolvedType toType) {
        if (!toType.isConvertableFrom(fromType) && !fromType.isConvertableFrom(toType)) {
            throw new BCException("can't convert from " + fromType + " to " + toType);
        }
        if (!toType.getWorld().isInJava5Mode() ? toType.needsNoConversionFrom(fromType) : toType.needsNoConversionFrom(fromType) && !(toType.isPrimitiveType() ^ fromType.isPrimitiveType())) {
            return;
        }
        if (toType.equals(ResolvedType.VOID)) {
            il.append(InstructionFactory.createPop(fromType.getSize()));
        } else {
            if (fromType.equals(ResolvedType.VOID)) {
                il.append(InstructionFactory.createNull(Type.OBJECT));
                return;
            }
            if (fromType.equals(UnresolvedType.OBJECT)) {
                Type to = BcelWorld.makeBcelType(toType);
                if (toType.isPrimitiveType()) {
                    String name = toType.toString() + "Value";
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, to, new Type[]{Type.OBJECT}, (short)184));
                } else {
                    il.append(fact.createCheckCast((ReferenceType)to));
                }
            } else if (toType.equals(UnresolvedType.OBJECT)) {
                Type from = BcelWorld.makeBcelType(fromType);
                String name = fromType.toString() + "Object";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{from}, (short)184));
            } else if (toType.getWorld().isInJava5Mode() && validBoxing.get(toType.getSignature() + fromType.getSignature()) != null) {
                Type from = BcelWorld.makeBcelType(fromType);
                Type to = BcelWorld.makeBcelType(toType);
                String name = (String)validBoxing.get(toType.getSignature() + fromType.getSignature());
                if (toType.isPrimitiveType()) {
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, to, new Type[]{Type.OBJECT}, (short)184));
                } else {
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{from}, (short)184));
                    il.append(fact.createCheckCast((ReferenceType)to));
                }
            } else if (fromType.isPrimitiveType()) {
                Type from = BcelWorld.makeBcelType(fromType);
                Type to = BcelWorld.makeBcelType(toType);
                try {
                    il.append(fact.createCast(from, to));
                }
                catch (RuntimeException e) {
                    il.append(fact.createCast(from, Type.INT));
                    il.append(fact.createCast(Type.INT, to));
                }
            } else {
                Type to = BcelWorld.makeBcelType(toType);
                il.append(fact.createCheckCast((ReferenceType)to));
            }
        }
    }

    public static InstructionList createConversion(InstructionFactory factory, Type fromType, Type toType) {
        return Utility.createConversion(factory, fromType, toType, false);
    }

    public static InstructionList createConversion(InstructionFactory fact, Type fromType, Type toType, boolean allowAutoboxing) {
        InstructionList il = new InstructionList();
        if ((fromType.equals(Type.BYTE) || fromType.equals(Type.CHAR) || fromType.equals(Type.SHORT)) && toType.equals(Type.INT)) {
            return il;
        }
        if (fromType.equals(toType)) {
            return il;
        }
        if (toType.equals(Type.VOID)) {
            il.append(InstructionFactory.createPop(fromType.getSize()));
            return il;
        }
        if (fromType.equals(Type.VOID)) {
            if (toType instanceof BasicType) {
                throw new BCException("attempting to cast from void to basic type");
            }
            il.append(InstructionFactory.createNull(Type.OBJECT));
            return il;
        }
        if (fromType.equals(Type.OBJECT) && toType instanceof BasicType) {
            String name = toType.toString() + "Value";
            il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, toType, new Type[]{Type.OBJECT}, (short)184));
            return il;
        }
        if (toType.equals(Type.OBJECT)) {
            if (fromType instanceof BasicType) {
                String name = fromType.toString() + "Object";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{fromType}, (short)184));
                return il;
            }
            if (fromType instanceof ReferenceType) {
                return il;
            }
            throw new RuntimeException();
        }
        if (fromType instanceof ReferenceType && ((ReferenceType)fromType).isAssignmentCompatibleWith(toType)) {
            return il;
        }
        if (allowAutoboxing) {
            if (toType instanceof BasicType && fromType instanceof ReferenceType) {
                String name = toType.toString() + "Value";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, toType, new Type[]{Type.OBJECT}, (short)184));
                return il;
            }
            if (fromType instanceof BasicType && toType instanceof ReferenceType) {
                String name = fromType.toString() + "Object";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{fromType}, (short)184));
                il.append(fact.createCast(Type.OBJECT, toType));
                return il;
            }
        }
        il.append(fact.createCast(fromType, toType));
        return il;
    }

    public static Instruction createConstant(InstructionFactory fact, int i) {
        Instruction inst;
        switch (i) {
            case -1: {
                inst = InstructionConstants.ICONST_M1;
                break;
            }
            case 0: {
                inst = InstructionConstants.ICONST_0;
                break;
            }
            case 1: {
                inst = InstructionConstants.ICONST_1;
                break;
            }
            case 2: {
                inst = InstructionConstants.ICONST_2;
                break;
            }
            case 3: {
                inst = InstructionConstants.ICONST_3;
                break;
            }
            case 4: {
                inst = InstructionConstants.ICONST_4;
                break;
            }
            case 5: {
                inst = InstructionConstants.ICONST_5;
            }
        }
        inst = i <= 127 && i >= -128 ? new BIPUSH((byte)i) : (i <= Short.MAX_VALUE && i >= Short.MIN_VALUE ? new SIPUSH((short)i) : new LDC(fact.getClassGen().getConstantPool().addInteger(i)));
        return inst;
    }

    public static JavaClass makeJavaClass(String filename, byte[] bytes) {
        try {
            ++testingParseCounter;
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), filename);
            return parser.parse();
        }
        catch (IOException e) {
            throw new BCException("malformed class file");
        }
    }

    public static String arrayToString(int[] a) {
        int len = a.length;
        if (len == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer("[");
        buf.append(a[0]);
        for (int i = 1; i < len; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static void replaceInstruction(InstructionHandle ih, BranchInstruction branchInstruction, LazyMethodGen enclosingMethod) {
        InstructionList il = enclosingMethod.getBody();
        BranchHandle fresh = il.append(ih, branchInstruction);
        Utility.deleteInstruction(ih, fresh, enclosingMethod);
    }

    public static void replaceInstruction(InstructionHandle ih, InstructionList replacementInstructions, LazyMethodGen enclosingMethod) {
        InstructionList il = enclosingMethod.getBody();
        InstructionHandle fresh = il.append(ih, replacementInstructions);
        Utility.deleteInstruction(ih, fresh, enclosingMethod);
    }

    public static void deleteInstruction(InstructionHandle ih, LazyMethodGen enclosingMethod) {
        Utility.deleteInstruction(ih, ih.getNext(), enclosingMethod);
    }

    public static void deleteInstruction(InstructionHandle ih, InstructionHandle retargetTo, LazyMethodGen enclosingMethod) {
        InstructionList il = enclosingMethod.getBody();
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters != null) {
            for (int i = targeters.length - 1; i >= 0; --i) {
                InstructionTargeter targeter = targeters[i];
                targeter.updateTarget(ih, retargetTo);
            }
            ih.removeAllTargeters();
        }
        try {
            il.delete(ih);
        }
        catch (TargetLostException e) {
            throw new BCException("this really can't happen");
        }
    }

    public static Instruction copyInstruction(Instruction i) {
        if (i instanceof Select) {
            Select freshSelect = (Select)i;
            InstructionHandle[] targets = new InstructionHandle[freshSelect.getTargets().length];
            for (int ii = 0; ii < targets.length; ++ii) {
                targets[ii] = freshSelect.getTargets()[ii];
            }
            SWITCH switchStatement = new SWITCH(freshSelect.getMatchs(), targets, freshSelect.getTarget());
            return (Select)switchStatement.getInstruction();
        }
        return i.copy();
    }

    public static int getSourceLine(InstructionHandle ih) {
        int lookahead = 0;
        while (lookahead++ < 100) {
            if (ih == null) {
                return -1;
            }
            InstructionTargeter[] ts = ih.getTargeters();
            if (ts != null) {
                for (int j = ts.length - 1; j >= 0; --j) {
                    InstructionTargeter t = ts[j];
                    if (!(t instanceof LineNumberTag)) continue;
                    return ((LineNumberTag)t).getLineNumber();
                }
            }
            ih = ih.getPrev();
        }
        return -1;
    }

    public static void setSourceLine(InstructionHandle ih, int lineNumber) {
        ih.addTargeter(new LineNumberTag(lineNumber));
    }

    public static int makePublic(int i) {
        return i & 0xFFFFFFF9 | 1;
    }

    public static int makePrivate(int i) {
        return i & 0xFFFFFFFA | 2;
    }

    public static BcelVar[] pushAndReturnArrayOfVars(ResolvedType[] proceedParamTypes, InstructionList il, InstructionFactory fact, LazyMethodGen enclosingMethod) {
        int len = proceedParamTypes.length;
        BcelVar[] ret = new BcelVar[len];
        for (int i = len - 1; i >= 0; --i) {
            ResolvedType typeX = proceedParamTypes[i];
            Type type = BcelWorld.makeBcelType(typeX);
            int local = enclosingMethod.allocateLocal(type);
            il.append(InstructionFactory.createStore(type, local));
            ret[i] = new BcelVar(typeX, local);
        }
        return ret;
    }

    public static boolean isConstantPushInstruction(Instruction i) {
        return i instanceof ConstantPushInstruction || i instanceof LDC;
    }

    public static boolean isSuppressing(AnnotationX[] anns, String lintkey) {
        if (anns == null) {
            return false;
        }
        boolean suppressed = false;
        for (int i = 0; !suppressed && i < anns.length; ++i) {
            if (!UnresolvedType.SUPPRESS_AJ_WARNINGS.getSignature().equals(anns[i].getBcelAnnotation().getTypeSignature())) continue;
            List vals = anns[i].getBcelAnnotation().getValues();
            if (vals == null || vals.size() == 0) {
                suppressed = true;
                continue;
            }
            ArrayElementValue array = (ArrayElementValue)((ElementNameValuePair)vals.get(0)).getValue();
            ElementValue[] values = array.getElementValuesArray();
            for (int j = 0; j < values.length; ++j) {
                SimpleElementValue value = (SimpleElementValue)values[j];
                if (!value.getValueString().equals(lintkey)) continue;
                suppressed = true;
            }
        }
        return suppressed;
    }

    public static List getSuppressedWarnings(AnnotationX[] anns, Lint lint) {
        if (anns == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Lint.Kind> suppressedWarnings = new ArrayList<Lint.Kind>();
        boolean found = false;
        for (int i = 0; !found && i < anns.length; ++i) {
            if (!UnresolvedType.SUPPRESS_AJ_WARNINGS.getSignature().equals(anns[i].getBcelAnnotation().getTypeSignature())) continue;
            found = true;
            List vals = anns[i].getBcelAnnotation().getValues();
            if (vals == null || vals.size() == 0) {
                suppressedWarnings.addAll(lint.allKinds());
                continue;
            }
            ArrayElementValue array = (ArrayElementValue)((ElementNameValuePair)vals.get(0)).getValue();
            ElementValue[] values = array.getElementValuesArray();
            for (int j = 0; j < values.length; ++j) {
                SimpleElementValue value = (SimpleElementValue)values[j];
                Lint.Kind lintKind = lint.getLintKind(value.getValueString());
                if (lintKind == null) continue;
                suppressedWarnings.add(lintKind);
            }
        }
        return suppressedWarnings;
    }

    public static boolean isSimple(Method method) {
        if (method.getCode() == null) {
            return true;
        }
        if (method.getCode().getCode().length > 10) {
            return false;
        }
        InstructionList instrucs = new InstructionList(method.getCode().getCode());
        for (InstructionHandle InstrHandle = instrucs.getStart(); InstrHandle != null; InstrHandle = InstrHandle.getNext()) {
            BranchInstruction BI;
            Instruction Instr = InstrHandle.getInstruction();
            short opCode = Instr.getOpcode();
            if (!(Instr instanceof BranchInstruction ? (BI = (BranchInstruction)Instr).getIndex() < 0 : Instr instanceof InvokeInstruction)) continue;
            return false;
        }
        return true;
    }

    static {
        validBoxing.put("Ljava/lang/Byte;B", "byteObject");
        validBoxing.put("Ljava/lang/Character;C", "charObject");
        validBoxing.put("Ljava/lang/Double;D", "doubleObject");
        validBoxing.put("Ljava/lang/Float;F", "floatObject");
        validBoxing.put("Ljava/lang/Integer;I", "intObject");
        validBoxing.put("Ljava/lang/Long;J", "longObject");
        validBoxing.put("Ljava/lang/Short;S", "shortObject");
        validBoxing.put("Ljava/lang/Boolean;Z", "booleanObject");
        validBoxing.put("BLjava/lang/Byte;", "byteValue");
        validBoxing.put("CLjava/lang/Character;", "charValue");
        validBoxing.put("DLjava/lang/Double;", "doubleValue");
        validBoxing.put("FLjava/lang/Float;", "floatValue");
        validBoxing.put("ILjava/lang/Integer;", "intValue");
        validBoxing.put("JLjava/lang/Long;", "longValue");
        validBoxing.put("SLjava/lang/Short;", "shortValue");
        validBoxing.put("ZLjava/lang/Boolean;", "booleanValue");
        testingParseCounter = 0;
    }
}

