/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.authorization.access;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.authorization.IResourceAuthorizerConsumer;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class FindAllResourcesAuthorizedToUserInApplicationCommand
extends AbstractCommand<List<Resource>> {
    private IResourceAuthorizerConsumer resourceAuthorizerConsumer;
    private String userLoginArg;

    public IResourceAuthorizerConsumer getResourceAuthorizerConsumer() {
        return this.resourceAuthorizerConsumer;
    }

    public void setResourceAuthorizerConsumer(IResourceAuthorizerConsumer resourceAuthorizerConsumer) {
        this.resourceAuthorizerConsumer = resourceAuthorizerConsumer;
    }

    public String getUserLoginArg() {
        return this.userLoginArg;
    }

    public void setUserLoginArg(String userLoginArg) {
        this.userLoginArg = userLoginArg;
    }

    @Override
    protected void executeConsume() {
        MessageHeader messageHeader = super.getMessageHeader();
        String userLogin = this.getUserLoginArg();
        if (Validator.isNullOrEmpty((String)userLogin)) {
            userLogin = super.getUserContextIdentifier().getCurrentUserContext().getLoggedUser().getLogin();
        }
        super.setReturnMessage(this.getResourceAuthorizerConsumer().findAllInApplication(messageHeader, userLogin));
    }
}

