/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.management.basic.application;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.management.basic.IApplicationManagerConsumer;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class FindAllApplicationsInEnvironmentCommand
extends AbstractCommand<List<Application>> {
    private IApplicationManagerConsumer applicationManagerConsumer;
    private String regionalIdArg;
    private String environmentIdArg;

    public IApplicationManagerConsumer getApplicationManagerConsumer() {
        return this.applicationManagerConsumer;
    }

    public void setApplicationManagerConsumer(IApplicationManagerConsumer applicationManagerConsumer) {
        this.applicationManagerConsumer = applicationManagerConsumer;
    }

    public String getRegionalIdArg() {
        return this.regionalIdArg;
    }

    public void setRegionalIdArg(String regionalIdArg) {
        this.regionalIdArg = regionalIdArg;
    }

    public String getEnvironmentIdArg() {
        return this.environmentIdArg;
    }

    public void setEnvironmentIdArg(String environmentIdArg) {
        this.environmentIdArg = environmentIdArg;
    }

    @Override
    protected void executeConsume() {
        MessageHeader mh = this.getMessageHeader();
        if (Validator.isNullOrEmpty((String)this.getRegionalIdArg()) && Validator.isNullOrEmpty((String)this.getEnvironmentIdArg())) {
            Environment currentEnvironment = super.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment().getEnvironment();
            super.setReturnMessage(this.getApplicationManagerConsumer().findAllInEnvironment(mh, currentEnvironment.getRegional().getId(), currentEnvironment.getId()));
        } else {
            super.setReturnMessage(this.getApplicationManagerConsumer().findAllInEnvironment(mh, this.getRegionalIdArg(), this.getEnvironmentIdArg()));
        }
    }
}

