/*
 * SecurityEndPoint
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap;

import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.server.service.soap.Security41Service;

import javax.xml.namespace.QName;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Endpoint do servico.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class SecurityEndPoint extends Security41Service {

    private static final String WSDL_LOCATION = SecuritySettings.getEndpointWsdl();
    private static final String NAMESPACE = "http://v41.soap.service.server.fwca.petrobras.com.br/";
    private static final String SERVICE_NAME = "Security41Service";
    
    /**
     * Cria um endpooint.
     * 
     * @throws MalformedURLException
     *             URL do WSDL do servi&ccedil; est&aacute; incorreta.
     * 
     */
    public SecurityEndPoint() throws MalformedURLException {
        super(new URL(WSDL_LOCATION), new QName(NAMESPACE, SERVICE_NAME));
    }
}

