/*
 * InternalUserAuthenticatorConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence � Petrobras e n�o pode ser utilizado fora desta empresa sem pr�via autoriza��o.
 * ----------------------------------
 * Esta classe segue o padr�o PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authentication;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authentication.IUserAuthenticatorConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.security.TokenUser;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementa��o SOAP de um consumidor de autentica��o de usu�rio interno.
 * 
 * @author Equipe de desenvolvimento do Sistema de Controle de Acesso
 *         Corporativo.
 */
public class UserAuthenticatorConsumerSoapImpl implements IUserAuthenticatorConsumer {

    /**
     * Constante de serializa��o.
     */
    private static final long serialVersionUID = -2307578170286670701L;
    
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthenticatorConsumerSoapImpl.class);

   /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.authentication.IInternalUserAuthenticatorConsumer#logon(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public ReturnMessage<TokenUser> logon(String regionalId,
            String environmentId, String applicationCatalogId,
            String applicationPassword, String internalUserLogin,
            String internalUserPassword, boolean isInternalUser,
            String userIpAddress) {

        //Obtem o DNS (melhor aproxima��o para o nome da m�quina) a partir do IP.
        //Coloca o IP e o DNS no header. -- MI = DNS para a Petrobras.

        SoapMessageHeader smh = new SoapMessageHeader();
        smh.setUserIP(userIpAddress);

        String userMI = null;
        if (userIpAddress != null){
        try {
                userMI = InetAddress.getByName(userIpAddress).getCanonicalHostName();
            } catch (UnknownHostException e) {
                //e.printStackTrace();
                LOGGER.info("Endereco Ip informado do usuario ("+userIpAddress+") é desconhecida ou inválida.");
            } catch (RuntimeException e){
                //e.printStackTrace();
                LOGGER.info("Erro de Runtime na obtencao do MI do usuario. IP informado = "+userIpAddress,e);
            }
        }

        smh.setUserMI(userMI);

        // Executa o servi�o SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .logon(smh, regionalId, environmentId, applicationCatalogId,
                        applicationPassword, internalUserLogin,
                        internalUserPassword, isInternalUser);

        // Converte o retorno.
        ReturnMessage<TokenUser> rm = ReturnMessageMounter
                .mountLocalObjectWithTokenUserValue(rmDTO);

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.authentication.IInternalUserAuthenticatorConsumer#logoff(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<Boolean> logoff(MessageHeader messageHeader) {

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servi�o SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .logoffUser(smh);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }

    public ReturnMessage<Boolean> validateCredentials(String userLogin, String userPassword, boolean isInternalUser) {

        LOGGER.info("Realizando a valida��o das credenciais do usu�rio usando consumidor de servi�o SOAP...");

        // Executa o servi�o SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().validateUserCredentials(null, userLogin, userPassword, isInternalUser);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Valida��o das credenciais do usu�rio realizado com sucesso usando consumidor de servi�o SOAP.");

        return rm;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ReturnMessage<String> getAuthenticationHandlerUrl(String url) {
        LOGGER.info("Recuperando a Url do handler de autentica��o...");
        SoapReturnMessage srm = ConsumeSoapUtil.getCurrentEndPoint().getAuthenticationHandlerUrlFor(url);
        ReturnMessage<String> rm =  ReturnMessageMounter.mountLocalObjectWithStringValue(srm);
        LOGGER.info("Url do handler de autetica��o recuperada.");
        return rm;
    }

}

