/*
 * InformationAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IInformationAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;

/**
 * Implementao SOAP de um consumidor de autorizador de informao.
 * @author Phelipe Perboires - JGTL
 * @since 2.0
 * @version 1.0
 *
 */
public class InformationAuthorizerConsumerSoapImpl implements
        IInformationAuthorizerConsumer {

    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -8908514639255589865L;

    /* [ Constantes ] */
    
    /* [ Operaes ] */

    public ReturnMessage<Boolean> isSharedToApplication(MessageHeader messageHeader, String regionalId, String applicationCatalogIdOwnerOfInformation, String informationId) {

     // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
            .isInformationSharedToApplication(smhDTO, regionalId, applicationCatalogIdOwnerOfInformation, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Operaes ] */
    
}
