package br.com.petrobras.security.consume.soap.connection;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.connection.IAreaConnectorConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;

/**
 * Implementao "SOAP" do consumidor do conector de rea.
 *
 */
public class AreaConnectorConsumerSoapImpl implements IAreaConnectorConsumer {

	private IUserContextIdentifier userContextIdentifier;

	public IUserContextIdentifier getUserContextIdentifier() {
		return userContextIdentifier;
	}

	public void setUserContextIdentifier(
			IUserContextIdentifier userContextIdentifier) {
		this.userContextIdentifier = userContextIdentifier;
	}

	@Override
	public ReturnMessage<Area> connect(MessageHeader messageHeader,
			String areaId) {

		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
		SoapMessageHeader smhDTO = MessageHeaderMounter
				.mountTransferObject(messageHeader);

		// Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().connectCurrentArea(smhDTO, areaId);

		// Converte o retorno.
		return ReturnMessageMounter.mountLocalObjectWithAreaValue(rmDTO, this
				.getUserContextIdentifier().getCurrentUserContext()
				.getLoggedUser().getPreferredLanguage(), this
				.getUserContextIdentifier().getCurrentUserContext()
				.getSupportedApplicationLanguages());
	}

}
