/*
 * AppEnvMngtAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ExpirationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.authorization.basic.ApplicationEnvironmentManagementAuthorization;
import br.com.petrobras.security.server.service.soap.ExpirationDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de gerenciador de autorizao de
 * gerenciamento de ambiente de aplicao.
 * 
 * @author Phelipe Perboires - JGTL
 * 
 */
public class AppEnvMngtAuthorizationManagerConsumerSoapImpl
        implements
        IApplicationEnvironmentManagementAuthorizationManagerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 395203023271037880L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */
        
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String userLogin, Expiration expiration, Boolean enabled) {        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().grantAppEnvManagementAuthorizationToUser(smhDTO, userLogin, expirationDTO, enabled);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().revokeAppEnvManagementAuthorizationFromUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#update(br.com.petrobras.security.consume.MessageHeader, java.lang.String, br.com.petrobras.security.model.Expiration, java.lang.Boolean)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String userLogin, Expiration expiration, Boolean enabled) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().updateAppEnvManagementAuthorizationOfUser(smhDTO, userLogin, expirationDTO, enabled);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#grantOwnerOption(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> grantOwnerOption(MessageHeader messageHeader,
            String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().grantOwnerOptionToAppEnvManagementAuthorizationrOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#grantWithOwnerOption(br.com.petrobras.security.consume.MessageHeader, java.lang.String, br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> grantWithOwnerOption(
            MessageHeader messageHeader, String userLogin, Expiration expiration, Boolean enabled) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().grantAppEnvManagementAuthorizationWithOwnerOptionToUser(smhDTO, userLogin, expirationDTO, enabled);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IApplicationEnvironmentManagementAuthorizationManagerConsumer#revokeOwnerOption(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> revokeOwnerOption(
            MessageHeader messageHeader, String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().revokeOwnerOptionFromAppEnvManagementAuthorizationrOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<List<ApplicationEnvironmentManagementAuthorization>> findAll(
            MessageHeader messageHeader) {
        
            // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
            SoapMessageHeader smhDTO = MessageHeaderMounter
                    .mountTransferObject(messageHeader);

            // Executa o servio SOAP.
            SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                    .getCurrentEndPoint().findAllApplicationEnvironmentManagementAuthorizations(smhDTO);

            // Converte o retorno.
            return ReturnMessageMounter.mountLocalObjectWithApplicationEnvironmentManagementAuthorizationListValue(srmwlvDTO, 
                    this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage());
    }

    public ReturnMessage<ApplicationEnvironmentManagementAuthorization> findByUserLogin(
            MessageHeader messageHeader, String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAppEnvManagementAuthorizationOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithApplicationEnvironmentManagementAuthorizationValue(srmDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage());
    }

    /* [ Operators ] */
    
}

