/*
 * EnvironmentAdministrationAuthorizationConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IEnvironmentAdministrationAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.authorization.configuration.EnvironmentAdministrationAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de gerenciador de autorizao de
 * administrao de ambiente.
 * 
 * @author Paulo Henrique - DMMD
 * 
 */
public class EnvironmentAdministrationAuthorizationConsumerSoapImpl 
    implements IEnvironmentAdministrationAuthorizationManagerConsumer, Serializable {

    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 4536838789186329023L;

    /* [ Constantes ] */
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */
    
    
    public ReturnMessage<List<EnvironmentAdministrationAuthorization>> findAll(
            MessageHeader messageHeader, String regionalId, String environmentId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllEnvironmentAdministrationAuthorization(smhDTO, regionalId, environmentId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithEnvironmentAdministrationAuthorizationListValue(srmwlvDTO);
    }

    public ReturnMessage<EnvironmentAdministrationAuthorization> findByUserLogin(
            MessageHeader messageHeader, String scope, String regionalId,
            String environmentId, String userLogin) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findEnvironmentAdministrationAuthorization(smhDTO, scope, regionalId, environmentId, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithEnvironmentAdministrationAuthorizationValue(srmwlvDTO);
    }


    
    
}

