/*
 * RoleResourceAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IRoleResourceAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ExpirationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.access.RoleResourceAuthorization;
import br.com.petrobras.security.server.service.soap.ExpirationDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de gerenciador de autorizao de papel
 * em recurso.
 * 
 * @author Equipe de desenvolvimento do Sistema de Controle de Acesso
 *         Corporativo.
 * @since 1.0
 * @version 1.0
 * 
 */
public class RoleResourceAuthorizationManagerConsumerSoapImpl implements
        IRoleResourceAuthorizationManagerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -8246429656852617939L;

    /* [ Constantes ] */

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceAuthorizationManagerConsumer#findAllOfRole(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String)
     */
    public ReturnMessage<List<RoleResourceAuthorization>> findAllOfRole(
            MessageHeader messageHeader, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResouceAuthorizationsOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleResourceAuthorizationListValue(srmwlvDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<List<RoleResourceAuthorization>> findAllOfRoleAndChildrenOfResource(MessageHeader messageHeader, String roleId, String resourceId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResouceAuthorizationsOfRoleAndChildrenOfResource(smhDTO, roleId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleResourceAuthorizationListValue(srmwlvDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<List<Role>> findAllRolesOfResource(MessageHeader messageHeader, String resourceId) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllRolesOfResource(smhDTO, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleListValue(srmwlvDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String roleId, String resourceId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantResourceAuthorizationToRole(smhDTO, roleId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String,
     *      br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String roleId, String resourceId, Expiration expiration) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter
                .mountTransferObject(expiration);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantResourceAuthorizationWithExpirationToRole(smhDTO, roleId,
                        resourceId, expirationDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String roleId, String resourceId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .revokeResourceAuthorizationFromRole(smhDTO, roleId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

}

