/*
 * UserRoleAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IUserRoleAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ContextValueSetMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.*;
import br.com.petrobras.security.model.authorization.IAuthorizationContextValue;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorization;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextValueSet;
import br.com.petrobras.security.server.service.soap.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Implementao SOAP do consumidor de gerenciador de autorizaes de papis para usurios
 */
public class UserRoleAuthorizationManagerConsumerSoapImpl implements IUserRoleAuthorizationManagerConsumer {

    private static final long serialVersionUID = -5256524611874441263L;

    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    @Override
    public ReturnMessage<List<Role>> findAllRolesOfUser(MessageHeader mh, String userLogin) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllRolesOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<Boolean> grant(MessageHeader mh, String userLogin, String roleId, List<ContextValueSet> contextValueSets) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = null;

        if (contextValueSets == null || contextValueSets.size() == 0) {
            rmDTO = ConsumeSoapUtil.getCurrentEndPoint().grantRoleToUser(smhDTO, userLogin, roleId);
        } else {
            List<ContextValueSetDTO> contextValueSetsDTO = ContextValueSetMounter.mountTransferList(contextValueSets, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
            rmDTO = ConsumeSoapUtil.getCurrentEndPoint().grantRoleToUserWithContext(smhDTO, userLogin, roleId, contextValueSetsDTO);
        }

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    @Override
    public ReturnMessage<Boolean> revoke(MessageHeader mh, String userLogin, String roleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().revokeRoleFromUser(smhDTO, userLogin, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<UserRoleAuthorization>> findAllUserRoleAuthorizationsOfRoleById(MessageHeader mh, String roleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllUserAuthorizationsOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter
            .mountLocalObjectWithUserRoleAuthorizationListValue(
                rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<List<UserRoleAuthorization>> findAllUserRoleAuthorizationsOfRoleByIdAndContextValueSet(MessageHeader mh, String roleId, ContextValueSet contextValueSet) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);
//teste
        List<String> contextIds = new ArrayList<String>(), contextValueIds = new ArrayList<String>();

        buildContextLists(contextValueSet, contextIds, contextValueIds);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllUserAuthorizationsOfRoleByIdAndContextValueSet(
                smhDTO,
                roleId,
                contextIds,
                contextValueIds);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithUserRoleAuthorizationListValue(
                        rmDTO,
                        this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                        this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    private void buildContextLists(ContextValueSet contextValueSet, List<String> contextIds, List<String> contextValueIds) {
        for (IAuthorizationContextValue authorizationContextValue : contextValueSet.getAuthorizationContextValues()){
            IContextValue contextValue = authorizationContextValue.getContextValue();

            contextIds.add(contextValue.getContext().getId());
            contextValueIds.add(contextValue.getId());
        }
    }

    @Override
    public ReturnMessage<List<User>> findAllUsersOfRoleByIdAndContextValueSet(MessageHeader mh, String roleId, ContextValueSet contextValueSet) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        List<String> contextIds = new ArrayList<String>(), contextValueIds = new ArrayList<String>();

        buildContextLists(contextValueSet, contextIds, contextValueIds);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllUsersOfRoleByIdAndContextValueSet(
                smhDTO,
                roleId,
                contextIds,
                contextValueIds);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<ContextValueSet>> findAllContextValueSets(MessageHeader messageHeader, String userLogin, String roleId) {
         // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllContextValueSetsOfUserRoleAuthorization(smhDTO, roleId, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithContextValueSetListValue(rmDTO,
            this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
            this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<Boolean> addContext(MessageHeader messageHeader, String userLogin, String roleId, List<ContextValueSet> contextValueSets) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        List<ContextValueSetDTO> contextValueSetsDTO = ContextValueSetMounter.mountTransferList(contextValueSets, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().addContextToUserRoleAuthorization(smhDTO, userLogin, roleId, contextValueSetsDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    @Override
    public ReturnMessage<Boolean> removeContext(MessageHeader messageHeader, String userLogin, String roleId, List<ContextValueSet> contextValueSets) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        List<ContextValueSetDTO> contextValueSetsDTO = ContextValueSetMounter.mountTransferList(contextValueSets, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().removeContextFromUserRoleAuthorization(smhDTO, userLogin, roleId, contextValueSetsDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<User>> findAllUsersOfRole(MessageHeader mh, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllUsersOfRole(
                smhDTO,
                roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

}

