/*
 * ContextManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IContextManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.IContext;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;

/**
 * Implementao SOAP do consumidor de gerenciamento de contexto.
 */
public class ContextManagerConsumerSoapImpl implements IContextManagerConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(ContextManagerConsumerSoapImpl.class);

    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    @Override
    public ReturnMessage<List<IContext>> findAll(MessageHeader messageHeader) {
        LOGGER.info("Realizando consulta de todos os contextos disponveis para a aplicao usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllContexts(smh);

        ReturnMessage<List<IContext>> rm = ReturnMessageMounter.mountLocalObjectWithContextListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Consulta de todos os contextos disponveis para a aplicao usando consumidor de servio SOAP concluida.");

        return rm;
    }

}
