 /*
 * DepartmentManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.enterprise;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.enterprise.IDepartmentManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.model.Department;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de departamento.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class DepartmentManagerConsumerSoapImpl implements
        IDepartmentManagerConsumer {

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IDepartmentManagerConsumer#find(br.com.petrobras.security.consume.MessageHeader, java.lang.Long, java.lang.Long)
     */
    public ReturnMessage<Department> find(MessageHeader messageHeader,
            Long departmentCode, Long companyCode) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findDepartmentByCode(smhDTO, departmentCode, companyCode);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithDepartmentValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IDepartmentManagerConsumer#find(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.Long)
     */
    public ReturnMessage<Department> find(MessageHeader messageHeader,
            String acronym, Long companyCode) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findDepartmentByAcronym(smhDTO, acronym, companyCode);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithDepartmentValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IDepartmentManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Department>> findAll(MessageHeader messageHeader) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllDepartments(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithDepartmentListValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IDepartmentManagerConsumer#findAllActive(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Department>> findAllActive(
            MessageHeader messageHeader) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllActiveDepartments(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithDepartmentListValue(rmDTO);
    }

}
