/*
 * UserInactivationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.inactivation;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ExpirationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.I18nStringMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.i18n.I18nString;
import br.com.petrobras.security.model.inactivation.UserInactivation;
import br.com.petrobras.security.server.service.soap.*;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao SOAP da interface de consumo de servio de gerenciamento de
 * inativao de usurio.
 * 
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 * 
 */
public class UserInactivationManagerConsumerSoapImpl implements
        IUserInactivationManagerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -6750764109912477334L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */

    private IUserContextIdentifier userContextIdentifier;

    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#findAllUserInactivations(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<UserInactivation>> findAllUserInactivations(
            MessageHeader messageHeader) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllUserInactivations(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithUserInactiovationListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#activateUser(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String,
     *      br.com.petrobras.security.model.i18n.I18nString,
     *      br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> activateUser(MessageHeader messageHeader,
            String activatedUserLogin, I18nString reason, Expiration expiration) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte os parametros locais em objetos de transferncia.
        I18NStringDTO translationReasonDTO = I18nStringMounter
                .mountTransferObject(reason, this.getUserContextIdentifier()
                        .getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .activateUser(smhDTO, activatedUserLogin, translationReasonDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#adddInactivationToUser(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String,
     *      br.com.petrobras.security.model.i18n.I18nString,
     *      br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> adddInactivationToUser(
            MessageHeader messageHeader, String inactivatedUserLogin,
            I18nString reason, Expiration expiration) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte os parametros locais em objetos de transferncia.
        ExpirationDTO expirationDTO = ExpirationMounter
                .mountTransferObject(expiration);
        I18NStringDTO translationReasonDTO = I18nStringMounter
                .mountTransferObject(reason, this.getUserContextIdentifier()
                        .getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .addInactivationToUser(smhDTO, inactivatedUserLogin,
                        expirationDTO, translationReasonDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#removeUserInactivation(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.Long, br.com.petrobras.security.model.i18n.I18nString)
     */
    public ReturnMessage<Boolean> removeUserInactivation(
            MessageHeader messageHeader, Long inactivationUid, I18nString reason) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte os parametros locais em objetos de transferncia.
        I18NStringDTO reasonDTO = I18nStringMounter.mountTransferObject(reason,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeInactivationOfUser(smhDTO, inactivationUid, reasonDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#updateUserInactivation(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.Long, br.com.petrobras.security.model.i18n.I18nString,
     *      br.com.petrobras.security.model.Expiration)
     */
    public ReturnMessage<Boolean> updateUserInactivation(
            MessageHeader messageHeader, Long inactivationUid,
            I18nString newReason, Expiration newExpiration) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte os parametros locais em objetos de transferncia.
        ExpirationDTO expirationDTO = ExpirationMounter
                .mountTransferObject(newExpiration);
        I18NStringDTO newReasonDTO = I18nStringMounter.mountTransferObject(
                newReason, this.getUserContextIdentifier()
                        .getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateInactivationOfUser(smhDTO, inactivationUid,
                        expirationDTO, newReasonDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#findAllInactivatedUsers(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<User>> findAllInactivatedUsers(
            MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllInactivatedUsers(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#findAllOfUser(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String)
     */
    public ReturnMessage<List<UserInactivation>> findAllOfUser(
            MessageHeader messageHeader, String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllInactivationsOfUser(smhDTO,
                        userLogin);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithUserInactiovationListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.inactivation.IUserInactivationManagerConsumer#findByUid(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.Long)
     */
    public ReturnMessage<UserInactivation> findByUid(
            MessageHeader messageHeader, Long uid) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findUserInactivationByUid(smhDTO, uid);

        // Convete o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserInactivationValue(
                rmDTO, this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /* [ Operators ] */

}

