/*
 * ApplicationEnvironmentManagementAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.basic.ApplicationEnvironmentManagementAuthorization;
import br.com.petrobras.security.server.service.soap.ApplicationEnvironmentManagementAuthorizationDTO;

import java.util.Locale;

public class ApplicationEnvironmentManagementAuthorizationMounter {

    /**
     * Monta um gestor de aplicao a partir de um gestor de aplicao de transferncia.
     * @param appEnvManagementAuthorizationDTO Gestor de aplicao de transferncia.
     * @param preferredUserLocale Idioma preferido do usuario.
     * @return Gestor de aplicao.
     */
    public static ApplicationEnvironmentManagementAuthorization mountLocalObject (
            ApplicationEnvironmentManagementAuthorizationDTO appEnvManagementAuthorizationDTO, Locale preferredUserLocale) {
        if (appEnvManagementAuthorizationDTO == null) {
            return null;
        } else {
            ApplicationEnvironmentManagementAuthorization appEnvManagementAuthorization = new ApplicationEnvironmentManagementAuthorization ();

            appEnvManagementAuthorization.setUid(appEnvManagementAuthorizationDTO.getUid());
            appEnvManagementAuthorization.setDataAuthorization(appEnvManagementAuthorizationDTO.isDataAuthorization());
            appEnvManagementAuthorization.setEnabled(appEnvManagementAuthorizationDTO.isEnabled());
            appEnvManagementAuthorization.setOwner(appEnvManagementAuthorizationDTO.isOwner());
            
            appEnvManagementAuthorization.setArea(AreaMounter.mountLocalObject(
            		appEnvManagementAuthorizationDTO.getArea(), preferredUserLocale, null));
            appEnvManagementAuthorization.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(
                    appEnvManagementAuthorizationDTO.getApplicationEnvironment(), preferredUserLocale));
            appEnvManagementAuthorization.setUser(UserMounter.mountModelObject(appEnvManagementAuthorizationDTO.getUser()));
            appEnvManagementAuthorization.setExpiration(ExpirationMounter.mountLocalObject(appEnvManagementAuthorizationDTO.getExpiration()));
            
            return appEnvManagementAuthorization;
        }            
    }
    
    /**
     * Monta um gestor de aplicao de transferncia a partir de um gestor de aplicao.
     * @param appEnvManagementAuthorization Ambiente de aplicao.
     * @return Ambiente de aplicao de transferncia
     */
    public static ApplicationEnvironmentManagementAuthorizationDTO mountTransferObject(
            ApplicationEnvironmentManagementAuthorization appEnvManagementAuthorization) {
        if (appEnvManagementAuthorization == null) {
            return null;
        } else {
            ApplicationEnvironmentManagementAuthorizationDTO appEnvManagementAuthorizationDTO = new ApplicationEnvironmentManagementAuthorizationDTO ();

            appEnvManagementAuthorizationDTO.setUid (appEnvManagementAuthorization.getUid());
            appEnvManagementAuthorizationDTO.setEnabled(appEnvManagementAuthorization.isEnabled());
            appEnvManagementAuthorizationDTO.setOwner(appEnvManagementAuthorization.isOwner());
            
            appEnvManagementAuthorizationDTO.setUser(UserMounter.mountTransferObject(appEnvManagementAuthorization.getUser()));
            appEnvManagementAuthorizationDTO.setArea(AreaMounter.mountTransferObject(appEnvManagementAuthorization.getArea(),null));
            appEnvManagementAuthorizationDTO.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(appEnvManagementAuthorization.getApplicationEnvironment()));
            appEnvManagementAuthorizationDTO.setExpiration(ExpirationMounter.mountTransferObject(appEnvManagementAuthorization.getExpiration()));

            return appEnvManagementAuthorizationDTO;
        }
    }
}

