/*
 * AuthorizationContextValueMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.authorization.IAuthorizationContextValue;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextInformationValue;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextValueSet;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.AuthorizationContextValueDTO;
import br.com.petrobras.security.server.service.soap.InformationValueDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AuthorizationContextValueMounter {

    public static AuthorizationContextValueDTO mountTransferObject(IAuthorizationContextValue authorizationContextValue, Long contextValueSetUid) {

        if (authorizationContextValue == null) {
            return null;
        }

        AuthorizationContextValueDTO dto = new AuthorizationContextValueDTO();
        dto.setUid(authorizationContextValue.getUid());

        dto.setContextValue(ContextValueMounter.mountTransferObject(authorizationContextValue.getContextValue()));

        dto.setContextValuesSetUid(contextValueSetUid);

        return dto;
    }

    public static List<IAuthorizationContextValue> mountLocalList(List<AuthorizationContextValueDTO> contextValuesObjectDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (contextValuesObjectDTO == null) {
            return null;
        }

        List<IAuthorizationContextValue> contextValues = new ArrayList<IAuthorizationContextValue> ();

        for (AuthorizationContextValueDTO contextValueDTO : contextValuesObjectDTO)
        {
            contextValues.add(mountLocalObject(contextValueDTO, preferredUserLanguage, supportedApplicationLanguages));
        }

        return contextValues;
    }

    public static IAuthorizationContextValue mountLocalObject(AuthorizationContextValueDTO contextValueDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (contextValueDTO == null) {
            return null;
        }

        UserRoleAuthorizationContextInformationValue contextValue = new UserRoleAuthorizationContextInformationValue();
        contextValue.setUid(contextValueDTO.getUid());
        contextValue.setContextValuesSet(new UserRoleAuthorizationContextValueSet(contextValueDTO.getContextValuesSetUid()));

        if (contextValueDTO.getContextValue() != null) {
            if (contextValueDTO.getContextValue() instanceof InformationValueDTO)
            {
                InformationValueDTO infoValueDTO = (InformationValueDTO) contextValueDTO.getContextValue();
                contextValue.setInformationValue(InformationValueMounter.mountLocalObject(infoValueDTO, preferredUserLanguage, supportedApplicationLanguages));

            } else {
                throw new InvalidOperationException("Valor de contexto do tipo '" + contextValueDTO.getContextValue().getClass().getSimpleName() + "' no  suportado por esta verso de API.");
            }
        }

        return contextValue;
    }

}
