/*
 * CompanyMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Company;
import br.com.petrobras.security.server.service.soap.CompanyDTO;

import java.io.Serializable;

/**
 * Montador de empresa.
 * 
 * @author Phelipe Perboires - JGTL, Eraldo Neto - HMGL
 * @since 1.0
 * @version 1.0
 */
public class CompanyMounter implements Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao
     */
    private static final long serialVersionUID = -7550739979010310322L;

    /* [ Constantes ] */

    /* [ Operaes ] */

    /**
     * Monta uma empresa do modelo a partir de uma empresa de transferncia.
     * 
     * @param compDTO
     *            Empresa de transferncia.
     * @return Empresa do modelo.
     */

    public static Company mountLocalObject(CompanyDTO compDTO) {
        if (compDTO == null) {
            return null;
        }

        Company comp = new Company();

        comp.setCode(compDTO.getCode());
        comp.setName(compDTO.getName());
        comp.setAcronym(compDTO.getAcronym());

        return comp;
    }

    /**
     * Monta uma empresa de transferncia a partir de uma empresa do modelo.
     * 
     * @param comp
     *            Empresa do modelo.
     * @return Empresa de transferncia.
     */

    public static CompanyDTO mountTranferObject(Company comp) {
        if (comp == null) {
            return null;
        }

        CompanyDTO compDTO = new CompanyDTO();
        
        compDTO.setCode(comp.getCode());
        compDTO.setName(comp.getName());
        compDTO.setAcronym(comp.getAcronym());

        return compDTO;
    }

    /* [ Operaes ] */

}
