/*
 * ContextMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.IContext;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.InformationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Montador de contexto.
 */
public class ContextMounter {

    /**
     * Monta um contexto a partir de um DTO do servio.
     * @param contextDTO DTO do servio.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Contexto montado.
     * @throws ClassCastException Tipo de contexto retornado pelo servio no  suportado por essa verso da API.
     */
	public static IContext mountLocalObject(Object contextDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages)
    throws
        ClassCastException
    {
        //
        if (contextDTO instanceof InformationDTO) {
            InformationDTO infoDTO = (InformationDTO)contextDTO;
            return InformationMounter.mountLocalObject(infoDTO, preferredUserLanguage, supportedApplicationLanguages);
        }

        throw new ClassCastException("Tipo de contexto retornado pelo servio no  suportado por essa verso da API.");
    }

    /**
     * Monta uma lista de contextos a partir de uma lista de DTOs do servio.
     * @param contextListDTO Lista de DTOs do servio.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Lista de contextos montados.
     * @throws ClassCastException Tipo de contexto retornado pelo servio no  suportado por essa verso de API.
     */
    public static List<IContext> mountLocalObject(List<Object> contextListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages)
    throws
        ClassCastException {

        if (contextListDTO == null) {
            return null;
        } else {
            List<IContext> contextList = new ArrayList<IContext>();

            for (Object objectContextDTO : contextListDTO) {

                IContext context = ContextMounter.mountLocalObject(objectContextDTO, preferredUserLanguage, supportedApplicationLanguages);

                if (context != null) {
                    contextList.add(context);
                }
            }

            return contextList;
        }
    }

}
