/*
 * UserRoleAuthorizationContextValueSetMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.authorization.IAuthorizationContextValue;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorization;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextValueSet;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ContextValueSetDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ContextValueSetMounter {

    public static List<ContextValueSetDTO> mountTransferList(List<ContextValueSet> contextValueSets, List<SupportedLanguage> supportedLanguages) {

        if (contextValueSets == null) {
            return null;
        }

        List<ContextValueSetDTO> contextValueSetsDTO = new ArrayList<ContextValueSetDTO>();

        for (ContextValueSet contextValueSet : contextValueSets) {
            contextValueSetsDTO.add(mountTransferObject(contextValueSet, supportedLanguages));
        }

        return contextValueSetsDTO;
    }

    public static ContextValueSetDTO mountTransferObject(ContextValueSet contextValueSet, List<SupportedLanguage> supportedLanguages) {
        if (contextValueSet == null) {
            return null;
        }

        ContextValueSetDTO dto = new ContextValueSetDTO();

        dto.setUid(contextValueSet.getUid());

        if (contextValueSet.getAuthorizationContextValues() != null && contextValueSet.getAuthorizationContextValues().size() > 0) {

            for (IAuthorizationContextValue authorizationContextValue : contextValueSet.getAuthorizationContextValues())
            {
                dto.getContextValues().add(AuthorizationContextValueMounter.mountTransferObject(authorizationContextValue, contextValueSet.getUid()));
            }
        }

        return dto;
    }

    public static List<ContextValueSet> mountLocalList(List<Object> contextValueSetsObjectDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages)
    {
        if (contextValueSetsObjectDTO == null)
        {
            return null;
        }

        List<ContextValueSet> contextValueSets = new ArrayList<ContextValueSet> ();

        for (Object contextValueSetObjectDTO : contextValueSetsObjectDTO)
        {
            ContextValueSetDTO contextValueSetDTO = (ContextValueSetDTO)contextValueSetObjectDTO;
            contextValueSets.add(mountLocalObject(contextValueSetDTO, preferredUserLanguage, supportedApplicationLanguages));
        }

        return contextValueSets;
    }

    public static ContextValueSet mountLocalObject(ContextValueSetDTO contextValueSetDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages)
    {
        if (contextValueSetDTO == null)
        {
            return null;
        }

        UserRoleAuthorizationContextValueSet userRoleAuthorizationContextValueSet = new UserRoleAuthorizationContextValueSet();

        userRoleAuthorizationContextValueSet.setUid(contextValueSetDTO.getUid());

        userRoleAuthorizationContextValueSet.setUserRoleAuthorization(new UserRoleAuthorization());
        userRoleAuthorizationContextValueSet.getUserRoleAuthorization().setUid(contextValueSetDTO.getAuthorizationUid());

        userRoleAuthorizationContextValueSet.setAuthorizationContextValues(AuthorizationContextValueMounter.mountLocalList(contextValueSetDTO.getContextValues(), preferredUserLanguage, supportedApplicationLanguages));

        return userRoleAuthorizationContextValueSet;
    }

}
