 /*
 * EnterpriseGroupUserTypeMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.EnterpriseGroupUserType;
import br.com.petrobras.security.server.service.soap.EnterpriseGroupUserTypeDTO;

/**
 * Montador de tipos de usurios de um grupo corporativo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupUserTypeMounter {

    /**
     * Monta tipo de usurios do grupo corporativo de transferncia a partir de
     * um tipo de usurios do grupo corporativo.
     * 
     * @param enterpriseGroupUserType Tipo de usurios de grupo corporativo.
     * @return Tipo de usurios do grupo corporativo de transferncia.
     */
    public static EnterpriseGroupUserTypeDTO mountTransferObject(
            EnterpriseGroupUserType enterpriseGroupUserType) {
        
        if (enterpriseGroupUserType == null){
            return null;
        }
        
        switch (enterpriseGroupUserType.getUserTypeCode()) {
        case 0:
            return EnterpriseGroupUserTypeDTO.ALL;
        case 1:
            return EnterpriseGroupUserTypeDTO.EMPLOYEE;
        case 2:
            return EnterpriseGroupUserTypeDTO.CONTRACTED_WORKER;
        default:
            throw new ClassCastException("Tipo de usurios do grupo corporativo invlido.");
        }
    }
    
    /**
     * Monta tipo de usurios do grupo corporativo a partir de
     * um tipo de usurios do grupo corporativo de transferncia.
     * 
     * @param enterpriseGroupUserTypeDTO Tipo de usurios do grupo corporativo de transferncia.
     * @return Tipo de usurios de grupo corporativo.
     */
    public static EnterpriseGroupUserType mountLocalObject(
            EnterpriseGroupUserTypeDTO enterpriseGroupUserTypeDTO) {

        if (enterpriseGroupUserTypeDTO == null){
            return null;
        }
        
        switch (enterpriseGroupUserTypeDTO) {
        case ALL:
            return EnterpriseGroupUserType.ALL;
        case EMPLOYEE:
            return EnterpriseGroupUserType.EMPLOYEE;
        case CONTRACTED_WORKER:
            return EnterpriseGroupUserType.CONTRACTED_WORKER;
        default:
            throw new ClassCastException("Tipo de usurios do grupo corporativo invlido.");
        }
    }

}
