 /*
 * FunctionMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Function;
import br.com.petrobras.security.server.service.soap.FunctionDTO;

/**
 * Montador de funo de empregado.
 * 
 * @author Eraldo Neto - HMGL
 * @since 3.0
 * @version 1.0
 * 
 */
public class FunctionMounter {

    /**
     * Monta uma funo de empregado do modelo a partir de uma funo de empregado de transferncia.
     * 
     * @param functionDTO
     *            Funo de empregado de transferncia.
     * @return Funo de empregado do modelo.
     */
    public static Function mountLocalObject(FunctionDTO functionDTO) {
        if (functionDTO == null) {
            return null;
        }

        Function function = new Function();

        function.setCode(functionDTO.getCode());
        function.setName(functionDTO.getName());
        function.setDescription(functionDTO.getDescription());
        
        return function;
    }

    /**
     * Monta uma funo de empregado de transferncia a partir de uma funo de empregado do modelo.
     * 
     * @param function
     *            Funo de empregado do modelo.
     * @return Funo de empregado de transferncia.
     */
    public static FunctionDTO mountTransferObject(Function function) {
        if (function == null) {
            return null;
        }

        FunctionDTO functionDTO = new FunctionDTO();
        functionDTO.setCode(function.getCode());
        functionDTO.setName(function.getName());
        functionDTO.setDescription(function.getDescription());
        
        return functionDTO;
    }
}
