/*
 * I18nStringMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.TranslationNotFoundException;
import br.com.petrobras.security.model.i18n.I18nString;
import br.com.petrobras.security.model.i18n.I18nUtil;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.I18NStringDTO;
import br.com.petrobras.security.server.service.soap.I18NStringDTO.Translations;
import br.com.petrobras.security.server.service.soap.I18NStringDTO.Translations.Entry;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class I18nStringMounter {

    public static I18nString mountModelObject(I18NStringDTO i18nStringDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedLanguages) {
        if (i18nStringDTO == null) {
            return null;
        }

        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();

        for (int i = 0; i < i18nStringDTO.getTranslations().getEntry().size(); i++) {
            Entry entry = (Entry) i18nStringDTO.getTranslations().getEntry()
                    .get(i);

            String languageCode = adaptToLocal(entry.getKey());
            String translation = entry.getValue();

            translations.put(languageCode, translation);
        }

        return new I18nString(translations, preferredUserLanguage,
                supportedLanguages);
    }

    public static I18NStringDTO mountTransferObject(I18nString i18nString,
            List<SupportedLanguage> supportedLanguages) {
        
        if (i18nString == null) {
            return null;
        }
        if (supportedLanguages == null) {
            return mountTransferObject(i18nString);
        }

        I18NStringDTO i18nStringDTO = new I18NStringDTO();
        Translations translations = new Translations();

        int i = 0;
        for (SupportedLanguage supportedLanguage : supportedLanguages) {
            String translation = null;

            if (supportedLanguages.size() > 1) {
                Locale language = I18nUtil.convertLanguageCodeToLocale(supportedLanguage.getLocale()
                        .getLanguageCode());

                if (i18nString.hasTranslation(language) == false) {
                    throw new TranslationNotFoundException(
                            "Esta aplicao est configurada para suportar mais de um idioma, porm no existe traduo para o idioma "
                                    + supportedLanguage.getLocale()
                                            .getLanguageCode()
                                    + " suportado por ela.");
                } else {
                    // Recupera a traduo do i18nString local para o cdigo do
                    // idioma atual.
                    translation = i18nString.get(language);
                }
            } else {
                translation = i18nString.get(I18nString.INDEX_PREFERRED_LANGUAGE);
            }

            Translations.Entry entry = new Translations.Entry();

            entry.setKey(adaptToTransfer(supportedLanguage.getLocale()
                    .getLanguageCode()));
            entry.setValue(translation);

            translations.getEntry().add(entry);

            i++;
        }

        i18nStringDTO.setTranslations(translations);

        return i18nStringDTO;
    }
    
    public static I18NStringDTO mountTransferObject(I18nString i18nString) {
        if (i18nString == null) { return null; }

        I18NStringDTO i18nStringDTO = new I18NStringDTO();
        i18nStringDTO.setTranslations(new Translations());

        int i = 0;
        for (Locale locale : i18nString.getKeys()) {
        	Translations.Entry entry = new Translations.Entry();

        	entry.setKey(adaptToTransfer(I18nUtil.convertLocaleToLanguageCode(locale)));
            entry.setValue(i18nString.get(locale));

            i18nStringDTO.getTranslations().getEntry().add(entry);
            i++;
        }

        return i18nStringDTO;
    }

    public static String adaptToTransfer(String languageCode) {
        languageCode = languageCode.toLowerCase(Locale.getDefault());
        return languageCode.replace('-', '_');
    }

    public static String adaptToLocal(String languageCode) {
        languageCode = languageCode.toLowerCase(Locale.getDefault());
        return languageCode;
    }

}

