package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.InformationSharingType;
import br.com.petrobras.security.model.InformationSharingTypeEnum;
import br.com.petrobras.security.server.service.soap.InformationSharingTypeEnumDTO;

public class InformationSharingTypeEnumMounter {

    /**
     * @param sharingType Objeto de modelo.
     * @return Objeto de transferencia.
     */
    public static InformationSharingTypeEnumDTO mountTransferObject(
            InformationSharingType sharingType) {

        Long sharingTypeUid = sharingType.getUid();

        if (sharingTypeUid == InformationSharingTypeEnum.NONE.getCode()) {
            
            return InformationSharingTypeEnumDTO.NONE;
            
        } else if (sharingTypeUid == InformationSharingTypeEnum.PER_APPLICATION.getCode()) {
            
            return InformationSharingTypeEnumDTO.PER_APPLICATION;
            
        } else if (sharingTypeUid == InformationSharingTypeEnum.ALL.getCode()) {
            
            return InformationSharingTypeEnumDTO.ALL;
            
        } else {
            return InformationSharingTypeEnumDTO.UNSUPPORTED;
        }
    }
    
}
