/*
 * MessageHeaderMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;

/**
 * Montador de cabealhos de mensagem.
 * 
 * @author JGTL
 */
public class MessageHeaderMounter {

    /**
     * Monta um cabeaho de mensagem de transferncia a partir de um cabealho
     * de mensagem.
     * 
     * @param messageHeader
     *            Cabeaho de mensagem.
     * @return Cabeaho de mensagem de transferncia.
     */
    public static SoapMessageHeader mountTransferObject(
            MessageHeader messageHeader) {
        if (messageHeader == null) {
            return null;
        } else {
            SoapMessageHeader soapMessageHeader = new SoapMessageHeader();

            if (messageHeader.getTicket() != null) {
                soapMessageHeader.setTicket(
                        TicketMounter.mountTransferObject(messageHeader.getTicket()));
            }

            if (messageHeader.getUserLocale() != null) {
                soapMessageHeader.setExecutionLanguageCode(messageHeader
                        .getUserLocale().getLanguageCode());
            }

            soapMessageHeader.setTargetAreaId(messageHeader.getTargetAreaId());
            soapMessageHeader.setExecutionTechnology(messageHeader.getExecutionTechnology());
            soapMessageHeader.setExecutionVersion(messageHeader.getExecutionVersion());

            return soapMessageHeader;
        }
    }

}

