 /*
 * ResourceGroupMembershipMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.ResourceGroupMembership;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.ResourceGroupMembershipDTO;

 import java.util.List;
 import java.util.Locale;

/**
 * Montador de membro de grupo de recursos.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class ResourceGroupMembershipMounter {

    /**
     * Monta um membro de grupo de recursos a partir de um membro de grupo de recursos de transferncia.
     * 
     * @param resourceGroupMembershipDTO Membro de grupo de recursos de transferncia..
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Membro de grupo de recursos.
     */
    public static ResourceGroupMembership mountLocalObject(
            ResourceGroupMembershipDTO resourceGroupMembershipDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (resourceGroupMembershipDTO == null )
        {
            return null;
        }
        else 
        {
            ResourceGroupMembership resourceGroupMembership = new ResourceGroupMembership ();

            resourceGroupMembership.setUid(resourceGroupMembershipDTO.getUid());
            
            resourceGroupMembership.setCreationDate(DateMounter.mountLocalObject(resourceGroupMembershipDTO.getCreationDate()));
            
            resourceGroupMembership.setResourceGroup(ResourceGroupMounter
                    .mountLocalObject(resourceGroupMembershipDTO
                            .getResourceGroup(), preferredUserLanguage,
                            supportedApplicationLanguages));
            
            resourceGroupMembership.setResource(ResourceMounter
                    .mountLocalObject(resourceGroupMembershipDTO.getResource(),
                            preferredUserLanguage,
                            supportedApplicationLanguages));
            
            return resourceGroupMembership;
        }            
    }
}
