/*
 * RoleAdministrationAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.RoleAdministrationAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleAdministrationAuthorizationDTO;

import java.util.List;
import java.util.Locale;

public class RoleAdministrationAuthorizationMounter {

    /**
     * Monta um autorizao de administrao em papel a partir de uma
     * autorizao de administrao em papel de transferncia.
     * 
     * @param roleAdministrationAuthorizationDTO
     *            Autorizao de administrao em papel de transferncia.
     * @param preferredUserLanguage
     * @param supportedApplicationLanguages
     * @return Autorizao de administrao em papel.
     */
    public static RoleAdministrationAuthorization mountLocalObject(
            RoleAdministrationAuthorizationDTO roleAdministrationAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleAdministrationAuthorizationDTO == null) {
            return null;
        } else {
            RoleAdministrationAuthorization roleAdministrationAuthorization = new RoleAdministrationAuthorization();

            // Montagem simples.
            roleAdministrationAuthorization
                    .setUid(roleAdministrationAuthorizationDTO.getUid());
            roleAdministrationAuthorization.setCreationDate(DateMounter
                    .mountLocalObject(roleAdministrationAuthorizationDTO
                            .getCreationDate()));

            // Montagem complexa.
            roleAdministrationAuthorization.setAdministrator(RoleMounter
                    .mountLocalObject(roleAdministrationAuthorizationDTO
                            .getAdminstratorRole(), preferredUserLanguage,
                            supportedApplicationLanguages));
            roleAdministrationAuthorization.setAdministered(RoleMounter
                    .mountLocalObject(roleAdministrationAuthorizationDTO
                            .getAdministeredRole(), preferredUserLanguage,
                            supportedApplicationLanguages));

            return roleAdministrationAuthorization;
        }
    }
}

