/*
 * RoleInformationContextListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.IRoleContext;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleInformationContextDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 *  Montador de lista de contextos aplicvel a papel.
 */
public class RoleContextListMounter {

    public static List<IRoleContext> mountLocalObjectList(List<Object> contextListDTO, Role role, Locale preferredUserLangauge, List<SupportedLanguage> supportedApplicationLanguages) {

        if (contextListDTO == null) {
            return null;
        }

        List<IRoleContext> contextList = new ArrayList<IRoleContext> ();

        for (Object contextDTO : contextListDTO) {

            if (contextDTO instanceof RoleInformationContextDTO) {
                contextList.add(RoleInformationContextMounter.mountLocalObject((RoleInformationContextDTO)contextDTO, role, preferredUserLangauge,supportedApplicationLanguages));
            } else {
                throw new UnsupportedOperationException("Tipo de contexto no suportado. Talvez seja preciso atualizar a API.");
            }
        }

        return contextList;
    }

}
