 /*
 * RoleResourceGroupAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.access.RoleResourceGroupAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.RoleResourceGroupAuthorizationDTO;

 import java.util.ArrayList;
 import java.util.List;
 import java.util.Locale;

/**
 * Montador de lista de autorizaes de papel em grupo de recursos.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class RoleResourceGroupAuthorizationListMounter {

    /**
     * Monta uma lista de autorizaes de papel em grupo de recurso a partir de uma
     * autorizao de papel em grupo de recurso de transferncia.
     * 
     * @param roleResourceGroupAuthorizationListDTO Autorizao de papel em grupo de recurso de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Lista de autorizaes de papel em grupo de recurso.
     */
    public static List<RoleResourceGroupAuthorization> mountLocalObjectList(
            List<Object> roleResourceGroupAuthorizationListDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleResourceGroupAuthorizationListDTO == null ) { return null; }
        else
        {
            List<RoleResourceGroupAuthorization> roleResourceGroupAuthorizationList = new ArrayList<RoleResourceGroupAuthorization> ();

            for (Object objectRoleResourceGroupAuthorizationDTO : roleResourceGroupAuthorizationListDTO) {
                RoleResourceGroupAuthorizationDTO roleResourceGroupAuthorizationDTO = (RoleResourceGroupAuthorizationDTO)objectRoleResourceGroupAuthorizationDTO;
                roleResourceGroupAuthorizationList.add(RoleResourceGroupAuthorizationMounter.mountLocalObject(roleResourceGroupAuthorizationDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return roleResourceGroupAuthorizationList;
        }
    }

}
