/*
 * UseCaseMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.UseCase;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UseCaseDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;


/**
 * Montador de casos de usos.
 * 
 * @author DMMD
 */
public class UseCaseMounter {

    /**
     * Monta um caso de uso a partir de um caso de uso de transferncia.
     * 
     * @param useCaseDTO
     *            Caso de uso de transferncia.
     * @return Caso de Uso.
     */
    public static UseCase mountLocalObject(UseCaseDTO useCaseDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages )
    {
        if (useCaseDTO == null)
        {
            return null;
        }
        else
        {
            UseCase useCase = new UseCase();

            // Montagem simples.

            useCase.setUid(useCaseDTO.getUid());
            useCase.setEnabled(useCaseDTO.isEnabled());
            useCase.setId(useCaseDTO.getId());
            useCase.setLogEnabled(useCaseDTO.isLogEnabled());
            useCase.setControlled(useCaseDTO.isControled());
            useCase.setGrcEnabled(useCaseDTO.isGrcEnabled());

            useCase.setType(UseCaseTypeMounter.mountLocalObject(useCaseDTO.getType()));
            
            useCase.setNameTranslations(I18nStringMounter.mountModelObject(useCaseDTO.getNameTranslations(),preferredUserLanguage,supportedApplicationLanguages));
            useCase.setDescriptionTranslations(I18nStringMounter.mountModelObject(useCaseDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return useCase;
        }
    }
    
    
    /**
     * Monta um caso de uso de transferncia a partir de um caso de uso.
     * 
     * @param useCase
     *            Caso de Uso.
     * @return Caso de Uso de transferncia.
     */

    public static UseCaseDTO mountTransferObject(UseCase useCase, List<SupportedLanguage> supportedApplicationLanguages) {
        if (useCase == null) {
            return null;
        } else {
            if (useCase.getNameTranslations() == null
                    || useCase.getDescriptionTranslations() == null) {
                throw new IllegalArgumentException(
                        "Traduo nula. Verifique a traduo dos atributos traduziveis.");

            } else {
                if (useCase.getNameTranslations().getCount() != useCase
                        .getDescriptionTranslations().getCount()) {
                    throw new IllegalArgumentException(
                            "Traduo incompleta. Verifique a traduo dos atributos traduziveis.");
                }
            }

            UseCaseDTO useCaseDTO = new UseCaseDTO();

            // Montagem simples.
            useCaseDTO.setUid(useCase.getUid());
            useCaseDTO.setId(useCase.getId());
            useCaseDTO.setEnabled(useCase.isEnabled());
            useCaseDTO.setControled(useCase.isControlled());
            useCaseDTO.setLogEnabled(useCase.isLogEnabled());
            useCaseDTO.setGrcEnabled(useCase.isGrcEnabled());

            try {
                useCaseDTO.setCreationDate(DateMounter
                        .mountTransferObject(useCase.getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de cadastro do caso de uso para enviar ao servio. "
                                + dtce.getMessage());
            }

            
            useCaseDTO.setType(UseCaseTypeMounter.mountTransferObject(useCase.getType()));
            
            // Montagem da I18n.
            useCaseDTO.setNameTranslations(I18nStringMounter.mountTransferObject(useCase.getNameTranslations(), supportedApplicationLanguages));
            useCaseDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(useCase.getDescriptionTranslations(), supportedApplicationLanguages));
            

            return useCaseDTO;
        }
    }

}

