/*
* @(#)UserInactivationMounter.java
*
*/
/*
 * UserInactivationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.model.inactivation.UserInactivation;
import br.com.petrobras.security.server.service.soap.UserInactivationDTO;

import java.util.List;
import java.util.Locale;

class UserInactivationMounter {

    public static UserInactivation mountLocalObject(UserInactivationDTO userInactivationDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedLanguages) {
        if (userInactivationDTO != null) {
            UserInactivation inactivation = new UserInactivation();

            inactivation.setUid(userInactivationDTO.getUid());
            inactivation.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(
                    userInactivationDTO.getApplicationEnvironment(), preferredUserLanguage));
            inactivation.setExpiration(ExpirationMounter.mountLocalObject(userInactivationDTO.getExpiration()));
            inactivation.setInactivator(UserMounter.mountModelObject(userInactivationDTO.getInactivator()));
            inactivation.setReasonTranslations(I18nStringMounter.mountModelObject(userInactivationDTO.getReasonTranslations(), preferredUserLanguage, supportedLanguages));
            inactivation.setInactivatedUser(UserMounter.mountModelObject(userInactivationDTO.getInactivated()));

            return inactivation;
        }
        else {
            return null;
        }
    }

}

