/*
 * UserMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.*;
import br.com.petrobras.security.server.service.soap.*;

/**
 * Montador de usurio.
 * 
 * @author Phelipe Perboires - JGTL
 * @author Paulo Henrique Ferreira - DMMD
 * @author Rodrigo Carvalho - UPM7
 * @since 1.0
 * @version 2.0
 */
public class UserMounter {

    /**
     * Monta um usurio do modelo a partir de um usurio de transferncia.
     * 
     * @param userDTO
     *            Usurio de transferncia.
     * @return Usurio do modelo.
     */
    public static User mountModelObject(UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }

        User user = null;
        if (userDTO instanceof ContractedWorkerUserDTO) {
            user = new ContractedWorkerUser();
            ContractedWorkerUserMounter.mountModelObject(
                    (ContractedWorkerUserDTO) userDTO,
                    (ContractedWorkerUser) user);
        } else if (userDTO instanceof EmployeeUserDTO) {
            user = new EmployeeUser();
            EmployeeUserMounter.mountModelObject((EmployeeUserDTO) userDTO,
                    (EmployeeUser) user);
        } else if (userDTO instanceof ExternalUserDTO) {
            user = new ExternalUser();
            ExternalUserMounter.mountModelObject((ExternalUserDTO) userDTO,
                    (ExternalUser) user);
        } else if (userDTO instanceof B2BUserDTO) {
            user = new B2BUser();
            B2BUserMounter.mountModelObject((B2BUserDTO) userDTO, (B2BUser) user);
        } else if (userDTO instanceof B2CUserDTO) {
            user = new B2CUser();
            B2CUserMounter.mountModelObject((B2CUserDTO) userDTO, (B2CUser) user);
        } else {
            user = new User();
            mountModelObject(userDTO, user);
        }
        return user;
    }

    static void mountModelObject(UserDTO userDTO, User user) {
        if (userDTO == null) {
            return;
        }

        // Simple.
        user.setLogin(userDTO.getLogin());
        user.setName(userDTO.getName());
        user.setEmail(userDTO.getEmail());
        user.setShortName(userDTO.getShortName());

        user.setPreferredLanguage(LocaleMounter
                .convertToUtilLocale(LocaleMounter.mountModelObject(userDTO
                        .getLocale())));
    }

    /**
     * Monta um usurio de transferncia a partir de um usurio do modelo.
     * 
     * @param user
     *            Usurio do modelo.
     * @return Usurio de transferncia.
     */
    public static UserDTO mountTransferObject(User user) {

        if (user == null) {
            return null;
        }

        UserDTO userDTO = null;
        if (user instanceof ContractedWorkerUser) {
            userDTO = new ContractedWorkerUserDTO();
            ContractedWorkerUserMounter.mountTransferObject(
                    (ContractedWorkerUser) user,
                    (ContractedWorkerUserDTO) userDTO);
        } else if (user instanceof EmployeeUser) {
            userDTO = new EmployeeUserDTO();
            EmployeeUserMounter.mountTransferObject((EmployeeUser) user,
                    (EmployeeUserDTO) userDTO);
        } else if (user instanceof ExternalUser) {
            userDTO = new ExternalUserDTO();
            ExternalUserMounter.mountTransferObject((ExternalUser) user,
                    (ExternalUserDTO) userDTO);
        } else {
            userDTO = new UserDTO();
            mountTransferObject(user, userDTO);
        }
        return userDTO;
    }

    static void mountTransferObject(User user, UserDTO userDTO) {
        // Simple.
        userDTO.setLogin(user.getLogin());
        userDTO.setName(user.getName());
        userDTO.setEmail(user.getEmail());
        userDTO.setShortName(user.getShortName());

        // Complex.
        userDTO.setLocale(LocaleMounter.mountTransferObject(LocaleMounter
                .convertToLocale(user.getPreferredLanguage())));
    }

    public static void updateLocalObject(UserDTO userDTO, User user) {
        if (user != null && userDTO != null) {
            if (user.getLogin().equals(userDTO.getLogin()) == false) {
                throw new InvalidOperationException(
                        "Login do usurio  diferente da login do usurio de transferncia.");
            }

            user.setName(userDTO.getName());
            user.setEmail(userDTO.getEmail());
        }
    }

}
