/*
 * UserRoleAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.UserRoleAuthorization;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextValueSet;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ContextValueSetDTO;
import br.com.petrobras.security.server.service.soap.UserRoleAuthorizationDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UserRoleAuthorizationMounter {

    /**
     * Monta uma autorizao de usurio em papel a partir de uma autorizao de usurio em papel de transferncia.
     * @param userRoleAuthorizationDTO Autorizao de usurio em papel de transferncia.
     * @return Autorizao de usurio em papel.
     */
    public static UserRoleAuthorization mountLocalObject(UserRoleAuthorizationDTO userRoleAuthorizationDTO,
                                                         Locale preferredUserLanguage,
                                                         List<SupportedLanguage> supportedApplicationLanguages) {
        if (userRoleAuthorizationDTO == null) {
            return null;
        } else {
            UserRoleAuthorization userRoleAuthorization = new UserRoleAuthorization();
            userRoleAuthorization.setUid(userRoleAuthorizationDTO.getUid());
            userRoleAuthorization.setCreationDate(DateMounter.mountLocalObject(userRoleAuthorizationDTO.getCreationDate()));
            userRoleAuthorization.setRole(RoleMounter.mountLocalObject(userRoleAuthorizationDTO.getRole(), preferredUserLanguage, supportedApplicationLanguages));
            userRoleAuthorization.setUser(UserMounter.mountModelObject(userRoleAuthorizationDTO.getUser()));

            List<ContextValueSetDTO> contextValuesSetsDTO = userRoleAuthorizationDTO.getContextValuesSets();
            List<UserRoleAuthorizationContextValueSet> list = new ArrayList<UserRoleAuthorizationContextValueSet>();
            for (ContextValueSetDTO contextValueSetDTO : contextValuesSetsDTO) {
                UserRoleAuthorizationContextValueSet contextValueSet = (UserRoleAuthorizationContextValueSet) ContextValueSetMounter.mountLocalObject(contextValueSetDTO, preferredUserLanguage, supportedApplicationLanguages);
                list.add(contextValueSet);
            }
            userRoleAuthorization.setContextValuesSets(list);
            return userRoleAuthorization;
        }
    }
    
    /**
     * Monta uma autorizao de usurio em papel de transferncia a partir de uma autorizao de usurio em papel.
     * @param userRoleAuthorization Ambiente de aplicao.
     * @return Ambiente de aplicao de transferncia
     * @throws DatatypeConfigurationException 
     */
    public static UserRoleAuthorizationDTO mountTransferObject (UserRoleAuthorization userRoleAuthorization,
            List<SupportedLanguage> supportedApplicationLanguages ) throws DatatypeConfigurationException
    {
        if (userRoleAuthorization == null )
        {
            return null;
        }
        else
        {
            UserRoleAuthorizationDTO userRoleAuthorizationDTO = new UserRoleAuthorizationDTO ();

            userRoleAuthorizationDTO.setUid (userRoleAuthorization.getUid());
            
            userRoleAuthorizationDTO.setUser(UserMounter.mountTransferObject(userRoleAuthorization.getUser()));
            userRoleAuthorizationDTO.setRole(RoleMounter.mountTransferObject(userRoleAuthorization.getRole(), supportedApplicationLanguages));
            userRoleAuthorizationDTO.setCreationDate(DateMounter.mountTransferObject(userRoleAuthorization.getCreationDate()));

            return userRoleAuthorizationDTO;
        }
    }
}

