package csbase.rest.adapter.job.v1.DAO;

import ibase.rest.api.job.v1.adapter.JobDAO;
import ibase.rest.api.job.v1.factories.JobsDAOFactory;

import java.util.Properties;

/**
 * Class factory para construir o DAO a partir do
 * Servio de Persistncia de Comandos.
 */
public class CSBaseCommandPersistJobDAOFactory implements JobsDAOFactory{

  /** Dao de jobs. */
  private static JobDAO jobDAO;

  @Override
  public JobDAO getJobDAO() {
    if (jobDAO == null) {
      jobDAO = new CommandPersistJobDAO();
    }
    return jobDAO;
  }

  @Override
  public void setProperties(Properties properties) {

  }
}
