/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.User;
import csbase.rest.adapter.job.v1.JobUtils;
import csbase.server.Service;
import csbase.server.services.commandpersistenceservice.CommandStatusListener;
import csbase.server.services.sgaservice.SGAService;
import ibase.rest.api.job.v2.adapter.JobDAO;
import ibase.rest.api.job.v2.adapter.JobMonitorListener;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.StatusChangeHistory;
import ibase.rest.model.job.v2.StatusType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JobInfoMonitor
implements CommandStatusListener {
    private final JobDAO jobDAO;
    private final ExecutorService listenerExecutor = Executors.newSingleThreadExecutor();
    private final List<JobMonitorListener> jobsListeners = new ArrayList<JobMonitorListener>();
    private Runnable UpdateJobInfoThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                JobInfoMonitor jobInfoMonitor = JobInfoMonitor.this;
                synchronized (jobInfoMonitor) {
                    while (JobInfoMonitor.this.jobsListeners.isEmpty()) {
                        try {
                            JobInfoMonitor.this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Service.setUserId((Object)User.getAdminId());
                Vector infos = SGAService.getInstance().getAllSGACommands();
                JobInfoMonitor.this.listenerExecutor.submit(() -> {
                    LinkedList<Job> jobs = new LinkedList<Job>();
                    for (CommandInfo info : infos) {
                        Job job;
                        if (info.getProgressData() == null || (job = JobInfoMonitor.this.jobDAO.findJobById(info.getId())) == null || info.getProgressData().getDescription().equals(job.getProgressInfo())) continue;
                        job.setProgressInfo(info.getProgressData().getDescription());
                        job.setSpecificData(info.getSpecificData());
                        job.setLastModifiedTime(LocalDateTime.now().toString());
                        JobInfoMonitor.this.jobDAO.updateJob(job);
                        jobs.add(job);
                    }
                    if (!jobs.isEmpty()) {
                        JobInfoMonitor.this.notifyListeners(jobs);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
        }
    };

    public JobInfoMonitor(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
        Executors.newSingleThreadExecutor().execute(this.UpdateJobInfoThread);
    }

    public synchronized void addJobMonitorListener(JobMonitorListener listener) {
        this.jobsListeners.add(listener);
        this.notify();
    }

    public synchronized void removeJobMonitorListener(JobMonitorListener listener) {
        this.jobsListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(List<Job> jobList) {
        JobMonitorListener[] jobMonitorListenerArray = this;
        synchronized (this) {
            JobMonitorListener[] listeners = this.jobsListeners.toArray(new JobMonitorListener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (JobMonitorListener listener : listeners) {
                listener.infoChanged(jobList);
            }
            return;
        }
    }

    public void statusChanged(CommandInfo commandInfo, CommandStatus newStatus) {
        this.listenerExecutor.submit(() -> {
            Job job = null;
            String commandId = commandInfo.getId();
            boolean skip = false;
            if (this.jobDAO.containsJob(commandId)) {
                job = this.jobDAO.findJobById(commandId);
                if (job.getStatusHistory() != null && job.getStatusHistory().size() > 0 && ((StatusChangeHistory)job.getStatusHistory().get(job.getStatusHistory().size() - 1)).getStatus().equals((Object)StatusType.SCHEDULED) && newStatus.equals((Object)CommandStatus.SCHEDULED)) {
                    skip = true;
                }
                if (!skip) {
                    this.jobDAO.updateJob(JobUtils.updateJob(job, commandInfo, newStatus));
                }
            } else {
                job = JobUtils.createJob(commandInfo, newStatus);
                this.jobDAO.insertJob(job);
            }
            if (job != null && !skip) {
                this.notifyListeners(Collections.singletonList(job));
            }
        });
    }
}

