package csbase.server.plugin.service.loginservice;

import java.util.Properties;
import csbase.logic.User;

/**
 * Interface pblica do servio de Login.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface ILoginService {
  
  public enum LoginProtocol {
    PROTOCOL_LOCAL,
    PROTOCOL_VOMS,
    PROTOCOL_LDAP
  }
    
  /**
   * Retorna o tipo do protocolo usado no login.
   * 
   * @return o tipo do protocolo
   */
  public abstract LoginProtocol getProtocolType();
  public abstract void setProperties(Properties pluginProperties);
  public abstract User authenticate(User user, String password);
}
