/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.ServiceFailureException;
import csbase.server.Server;
import csbase.server.services.projectservice.ServerProjectFile;
import csbase.server.services.projectservice.UpdatableFileInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import tecgraf.javautils.core.io.FileUtils;

class FileConfig {
    private static final String CONFIG_EXTENSION = ".csbase";
    static final String DESCRIPTION_EXTENSION = ".csbase_description";
    protected static final String TYPE = "TYPE";
    protected static final String UNDERCONSTRUCTION = "UNDERCONSTRUCTION";
    protected static final String CREATEDBY = "CREATEDBY";
    protected static final String CREATIONDATE = "CREATIONDATE";
    private static final String UPDATABLEFILEINFO = "UPDATABLEFILEINFO";
    private static final String PREFIX = ".";
    private static final String NFS_PREFIX = ".nfs";
    protected File file;
    protected File configFile;
    protected ServerProjectFile parent;
    protected boolean isUnderConstruction;
    protected String type;
    protected Object createdBy;
    protected long creationDate;
    protected UpdatableFileInfo updatableFileInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean readConfiguration() {
        boolean bl;
        ObjectInputStream in;
        block16: {
            in = null;
            if (this.configFile.isFile()) break block16;
            Server.logFineMessage("FileConfig:readConfigurationFile: " + this.configFile.getAbsolutePath() + " n\u00e3o \u00e9 arquivo ou n\u00e3o existe");
            boolean bl2 = false;
            FileUtils.close((Closeable)in);
            return bl2;
        }
        try {
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(this.configFile))));
            boolean flag = true;
            while (flag) {
                Object value;
                Object name;
                try {
                    name = in.readObject();
                    if (name == null) {
                        flag = false;
                        continue;
                    }
                    value = in.readObject();
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro na leitura de uma propriedade:  do arquivo de configuracao: " + this.configFile.getAbsolutePath(), e);
                    break;
                }
                if (name.equals(TYPE)) {
                    this.type = (String)value;
                    continue;
                }
                if (name.equals(UNDERCONSTRUCTION)) {
                    this.isUnderConstruction = (Boolean)value;
                    continue;
                }
                if (name.equals(CREATEDBY)) {
                    this.createdBy = value;
                    continue;
                }
                if (name.equals(CREATIONDATE)) {
                    this.creationDate = (Long)value;
                    continue;
                }
                if (name.equals(UPDATABLEFILEINFO)) {
                    this.updatableFileInfo = (UpdatableFileInfo)value;
                    continue;
                }
                Server.logInfoMessage("FileConfig:readConfigurationFile: " + name + " ignorado em " + this.configFile.getAbsolutePath());
            }
            bl = true;
        }
        catch (EOFException e) {
            this.type = "UNKNOWN";
            this.isUnderConstruction = false;
            this.createdBy = "admin";
            this.creationDate = new Date().getTime();
            this.writeConfiguration();
            boolean bl3 = true;
            FileUtils.close((Closeable)in);
            return bl3;
        }
        catch (Exception e2) {
            Server.logSevereMessage("FileConfig:readConfigurationFile: " + this.configFile.getAbsolutePath() + " corrompido.", e2);
            boolean bl4 = false;
            {
                catch (Throwable throwable) {
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close((Closeable)in);
            return bl4;
        }
        FileUtils.close((Closeable)in);
        return bl;
    }

    public void writeConfiguration() {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.configFile))));
            out.writeObject(TYPE);
            out.writeObject(new String(this.type));
            out.writeObject(UNDERCONSTRUCTION);
            out.writeObject(new Boolean(this.isUnderConstruction));
            out.writeObject(CREATEDBY);
            out.writeObject(this.createdBy);
            out.writeObject(CREATIONDATE);
            out.writeObject(new Long(this.creationDate));
            out.writeObject(UPDATABLEFILEINFO);
            out.writeObject(this.updatableFileInfo);
            out.writeObject(null);
        }
        catch (Exception e) {
            try {
                Server.logSevereMessage("FileConfig:writeConfigurationFile: erro ao gerar " + this.configFile.getAbsolutePath(), e);
                throw new ServiceFailureException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close((Closeable)out);
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public File getFile() {
        return this.file;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public static boolean isConfigFile(File file) {
        return FileConfig.isConfigFileName(file.getName());
    }

    public static boolean isDescriptionFile(File file) {
        return FileConfig.isDescriptionFileName(file.getName());
    }

    public static boolean isConfigFileName(String fileName) {
        return fileName.startsWith(PREFIX) && fileName.endsWith(CONFIG_EXTENSION);
    }

    public static boolean isDescriptionFileName(String fileName) {
        return fileName.startsWith(PREFIX) && fileName.endsWith(DESCRIPTION_EXTENSION);
    }

    public static boolean isUnixFileName(String fileName) {
        return fileName.startsWith(NFS_PREFIX);
    }

    public static boolean isControlledFileName(String fileName) {
        return FileConfig.isConfigFileName(fileName) || FileConfig.isDescriptionFileName(fileName) || FileConfig.isUnixFileName(fileName);
    }

    protected static File renamedFile(File file, String name) {
        String fileName = file.getName();
        String filePath = file.getAbsolutePath();
        String dir = filePath.substring(0, filePath.length() - fileName.length());
        return new File(dir + name);
    }

    protected static File renamedConfigFile(File file) {
        String fileName = file.getName();
        return FileConfig.renamedFile(file, FileConfig.createConfigFileName(fileName));
    }

    protected static File renamedDescriptionFile(File file) {
        String fileName = file.getName();
        return FileConfig.renamedFile(file, FileConfig.createDescriptionFileName(fileName));
    }

    protected static String createConfigFileName(String fileName) {
        String prefix = PREFIX;
        String ext = CONFIG_EXTENSION;
        return prefix + fileName + ext;
    }

    protected static String createDescriptionFileName(String fileName) {
        String prefix = PREFIX;
        String ext = DESCRIPTION_EXTENSION;
        return prefix + fileName + ext;
    }

    protected FileConfig(File file) {
        this.file = file;
        this.configFile = FileConfig.renamedConfigFile(file);
        this.isUnderConstruction = false;
        this.type = "UNKNOWN";
        this.createdBy = null;
        this.creationDate = 0L;
    }
}

