/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectFileTypeInfo;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

class ServerProjectFileType {
    private static ServerProjectFileType instance;
    private String resourceName;
    private Hashtable<String, ProjectFileTypeInfo> fileTypes;
    private Locale locale;

    public static ServerProjectFileType getInstance() {
        if (instance == null) {
            instance = new ServerProjectFileType();
        }
        return instance;
    }

    private Properties loadProperties() {
        try {
            Properties properties = new Properties();
            InputStream in = this.getClass().getResourceAsStream(this.resourceName);
            if (in == null) {
                throw new ServiceFailureException(this.resourceName + " n\u00e3o encontrado.");
            }
            properties.load(in);
            in.close();
            return properties;
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable<String, ProjectFileTypeInfo> getAllTypes(Locale loc) {
        this.loadFileTypes(loc);
        return this.fileTypes;
    }

    public ProjectFileTypeInfo getFileType(String typeCode) {
        ProjectFileTypeInfo info;
        if (this.fileTypes == null) {
            Locale loc = ProjectService.getInstance().getDefaultLocale();
            this.loadFileTypes(loc);
        }
        if ((info = this.fileTypes.get(typeCode)) == null) {
            info = this.fileTypes.get("UNKNOWN");
        }
        return info;
    }

    private void loadFileTypes(Locale loc) {
        if (this.fileTypes != null && this.locale != null && this.locale.equals(loc)) {
            return;
        }
        Properties properties = this.loadProperties();
        if (this.fileTypes == null) {
            ProjectFileTypeInfo fileType;
            this.fileTypes = new Hashtable();
            int i = 0;
            while ((fileType = this.makeFileType(properties, i, loc)) != null) {
                this.fileTypes.put(fileType.typeCode, fileType);
                ++i;
            }
        } else {
            Enumeration<String> e = this.fileTypes.keys();
            while (e.hasMoreElements()) {
                String description;
                String typeCode = e.nextElement();
                this.fileTypes.get((Object)typeCode).description = description = this.getDescription(typeCode, properties, loc);
            }
        }
        this.locale = loc;
    }

    public String getMimeType(String type) {
        String mimeType;
        if (this.fileTypes == null) {
            this.loadFileTypes(null);
        }
        if ((mimeType = this.fileTypes.get((Object)type).mimeType) == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    private ProjectFileTypeInfo makeFileType(Properties properties, int id, Locale loc) {
        String typeCode = this.getTypeCode(id, properties);
        if (typeCode == null) {
            return null;
        }
        try {
            String description = this.getDescription(typeCode, properties, loc);
            String mimeType = this.getMimeType(typeCode, properties);
            byte[] baseIcon = this.getImage(typeCode, properties, "baseIcon");
            byte[] ucIcon = this.getImage(typeCode, properties, "ucIcon");
            byte[] cutIcon = this.getImage(typeCode, properties, "cutIcon");
            List<String> extensions = this.getExtensions(typeCode, properties);
            ProjectFileTypeInfo fileType = new ProjectFileTypeInfo(typeCode, description, mimeType, baseIcon, ucIcon, cutIcon, extensions);
            return fileType;
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage(), e);
            return null;
        }
    }

    private String getTypeCode(int i, Properties properties) {
        String propName = "filetype." + i + ".typeCode";
        String prop = properties.getProperty(propName);
        if (prop == null) {
            return null;
        }
        String code = prop.trim();
        return code;
    }

    private String getDescription(String typeCode, Properties properties, Locale loc) {
        if (loc == null) {
            return null;
        }
        String propName = "filetype." + typeCode + ".description_" + loc;
        String description = properties.getProperty(propName);
        return description;
    }

    private String getMimeType(String typeCode, Properties properties) {
        String propName = "filetype." + typeCode + ".mimeType";
        String mimeType = properties.getProperty(propName);
        return mimeType;
    }

    private byte[] getImage(String typeCode, Properties properties, String imageName) {
        byte[] image = null;
        try {
            String propName = "filetype." + typeCode + "." + imageName;
            String fileName = properties.getProperty(propName);
            InputStream fin = this.getClass().getResourceAsStream(fileName);
            BufferedInputStream in = new BufferedInputStream(fin);
            int size = ((InputStream)in).available();
            image = new byte[size];
            ((InputStream)in).read(image);
            fin.close();
        }
        catch (Exception e) {
            String errMsg = "A imagem (" + imageName + ") do tipo de arquivo " + typeCode + " nao foi encontrada.";
            Server.logWarningMessage(errMsg);
            image = this.fileTypes.get((Object)"UNKNOWN").baseIcon;
        }
        return image;
    }

    private List<String> getExtensions(String typeCode, Properties properties) {
        String propName = "filetype." + typeCode + ".extensions";
        String extensions = properties.getProperty(propName);
        if (extensions == null) {
            return null;
        }
        String[] extS = extensions.split(",");
        ArrayList<String> extVector = new ArrayList<String>(extS.length);
        for (int i = 0; i < extS.length; ++i) {
            extVector.add(extS[i].trim().toLowerCase());
        }
        return extVector;
    }

    public String getTypeFromExtension(String name) {
        int index;
        if (this.fileTypes == null) {
            this.loadFileTypes(null);
        }
        if ((index = name.lastIndexOf(".")) == -1) {
            return "UNKNOWN";
        }
        String extension = name.substring(index + 1);
        Enumeration<String> e = this.fileTypes.keys();
        while (e.hasMoreElements()) {
            String code = e.nextElement();
            ProjectFileTypeInfo typeInfo = this.fileTypes.get(code);
            if (typeInfo.extensions == null || !typeInfo.extensions.contains(extension.toLowerCase())) continue;
            return code;
        }
        return "UNKNOWN";
    }

    private ServerProjectFileType() {
        ProjectService srv = ProjectService.getInstance();
        this.resourceName = srv.getFileTypesProperty();
    }
}

