/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.server.Server;
import csbase.server.ServerException;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.externalcommand.ExternalCommand;

public class FileSystem {
    private static final String CP_COMMAND = "cp";
    public static final String PROPERTIES_DIR = "properties";

    public static long getSpace(String path, int group, long timeout) {
        Server server = Server.getInstance();
        String command = server.getStringProperty("DiskSpace.command");
        String[] cmdArray = FileSystem.createCommandArray(command, path);
        ExternalCommand process = new ExternalCommand(cmdArray);
        boolean ok = false;
        try {
            int retCode = timeout <= 0L ? process.waitFor() : process.waitFor(timeout);
            ok = retCode == 0;
        }
        catch (InterruptedException e) {
            process.destroy();
            String fmt = "Timeout (%d ms) na obten\u00e7\u00e3o de espa\u00e7o em [%s] - %s.";
            String exMsg = e.getMessage();
            String err = String.format(fmt, timeout, path, exMsg);
            Server.logSevereMessage(err);
            return -9L;
        }
        catch (IOException ioe) {
            String err = "Erro de I/O ao obter espa\u00e7o em disco";
            Server.logSevereMessage(err, ioe);
            return -8L;
        }
        if (!ok) {
            String stderr = process.getErrorOutput();
            stderr = stderr != null ? stderr : "---";
            String fmt = "Erro obtendo espa\u00e7o em [%s] (stdout = '%s').";
            Server.logSevereMessage(String.format(fmt, path, stderr));
            process.destroy();
            return -1L;
        }
        String stdout = process.getStandardOutput();
        if (stdout == null) {
            String fmt = "Stdout nulo obtendo espa\u00e7o em [%s].";
            Server.logSevereMessage(String.format(fmt, path));
            return -1L;
        }
        String regex = server.getStringProperty("DiskSpace.regex");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(stdout);
        if (!matcher.find()) {
            String fmt = "Falha de match na obten\u00e7\u00e3o de espa\u00e7o em [%s] (regex = '%s'; string = '%s').";
            String err = String.format(fmt, path, regex, stdout);
            Server.logSevereMessage(err);
            return -1L;
        }
        String strKbytes = matcher.group(group);
        try {
            long bytes = Long.parseLong(strKbytes) * 1024L;
            return bytes;
        }
        catch (NumberFormatException nfe) {
            String fmt = "M\u00e1 formata\u00e7\u00e3o na obten\u00e7\u00e3o de espa\u00e7o em [%s] ('%s').";
            String err = String.format(fmt, path, strKbytes);
            Server.logSevereMessage(err);
            return -1L;
        }
    }

    public static long getFreeSpace(String path, long timeout) {
        Server server;
        block4: {
            server = Server.getInstance();
            try {
                String propertyName = "FreeDiskSpace.group";
                boolean isNull = server.isPropertyNull("FreeDiskSpace.group");
                if (!isNull) break block4;
                File f = new File(path);
                if (f.exists()) {
                    return f.getUsableSpace();
                }
                return -1L;
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro obtendo espa\u00e7o", e);
                return -1L;
            }
        }
        int group = server.getIntProperty("FreeDiskSpace.group");
        return FileSystem.getSpace(path, group, timeout);
    }

    public static long getTotalSpace(String path, long timeout) {
        Server server;
        block4: {
            server = Server.getInstance();
            try {
                String propertyName = "TotalDiskSpace.group";
                boolean isNull = server.isPropertyNull("TotalDiskSpace.group");
                if (!isNull) break block4;
                File f = new File(path);
                if (f.exists()) {
                    return f.getTotalSpace();
                }
                return -1L;
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro obtendo espa\u00e7o", e);
                return -1L;
            }
        }
        int group = server.getIntProperty("TotalDiskSpace.group");
        return FileSystem.getSpace(path, group, timeout);
    }

    public static boolean moveRegularFile(File from, File to) {
        Server.logInfoMessage("FileSystem.moveRegularFile:  de: " + from.getAbsolutePath() + "  para: " + to.getAbsolutePath());
        if (!from.exists()) {
            Server.logSevereMessage("FileSystem.moveRegularFile: arquivo origem n\u00e3o existe: " + from.getAbsolutePath());
            return false;
        }
        if (!FileSystem.copyFile(from, to)) {
            return false;
        }
        if (from.delete()) {
            return true;
        }
        Server.logSevereMessage("FileSystem.moveRegularFile: Erro removendo arquivo origem: " + from.getAbsolutePath());
        return false;
    }

    public static boolean move(File from, File to) {
        if (!from.isDirectory()) {
            return FileSystem.moveRegularFile(from, to);
        }
        if (!to.mkdirs()) {
            Server.logSevereMessage("FileSystem.move: Erro na criando diret\u00f3rio(s) : " + to.getAbsolutePath());
            return false;
        }
        File[] children = from.listFiles();
        boolean success = true;
        int i = 0;
        while (i < children.length) {
            File newChildFile = new File(to, children[i].getName());
            success = FileSystem.move(children[i], newChildFile);
            if (!success) break;
            ++i;
        }
        if (success) {
            if (from.delete()) {
                return true;
            }
            Server.logSevereMessage("FileSystem.move: Erro removendo diret\u00f3rio origem: " + from.getAbsolutePath());
        }
        return success;
    }

    public static boolean copyFile(File from, File to) {
        Server.logInfoMessage(String.format("FileSystem.copyFile: de '%s' para '%s'", from.getAbsolutePath(), to.getAbsolutePath()));
        String[] cmdArray = FileSystem.createCommandArray(CP_COMMAND, from.getAbsolutePath(), to.getAbsolutePath());
        String cmd = String.format("FileSystem:copyFile: Erro copiando arquivo (%s '%s' '%s')", cmdArray[0], cmdArray[1], cmdArray[2]);
        try {
            ExternalCommand command = new ExternalCommand(cmdArray);
            if (command.waitFor() != 0) {
                String errorOutput = command.getErrorOutput();
                Server.logSevereMessage(String.valueOf(cmd) + " :\n" + (errorOutput != null ? errorOutput : "---"));
                return false;
            }
        }
        catch (InterruptedException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        catch (IOException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        return true;
    }

    public static final boolean enableExecutionPermission(String filePath) throws ServerException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath == null");
        }
        if (filePath.equals("")) {
            throw new IllegalArgumentException("filePath est\u00e1 vazia");
        }
        try {
            return new File(filePath).setExecutable(true, false);
        }
        catch (Exception e) {
            throw new ServerException("Erro ao mudar execu\u00e7\u00e3o do arquivo '" + filePath + "'", e);
        }
    }

    private static String[] createCommandArray(String cmd, String ... args) {
        StringTokenizer cmdTokenizer = new StringTokenizer(cmd);
        int numTokens = cmdTokenizer.countTokens();
        String[] cmdArray = new String[args.length + numTokens];
        int i = 0;
        while (i < numTokens) {
            cmdArray[i++] = cmdTokenizer.nextToken();
        }
        System.arraycopy(args, 0, cmdArray, i, args.length);
        return cmdArray;
    }
}

