/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.server.ServerLogRecord;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ServerLogFormatter
extends Formatter {
    private final String LINE_SEPARATOR = "\n";

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat dateHourFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        dateHourFormat.setLenient(false);
        String date = dateHourFormat.format(record.getMillis());
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(date);
        sb.append(" ");
        if (record instanceof ServerLogRecord) {
            ServerLogRecord serverRecord = (ServerLogRecord)record;
            if (record.getLevel().equals(Level.SEVERE)) {
                sb.append(this.formatStackTraceElement(serverRecord.getMethod()));
            } else {
                sb.append(record.getLoggerName());
            }
            sb.append(" --- ");
            if (serverRecord.getUser() != null) {
                sb.append("(");
                sb.append(serverRecord.getUser().getId());
                sb.append(") ");
            }
        } else {
            sb.append(record.getLoggerName());
            sb.append(" --- ");
        }
        String message = this.formatMessage(record);
        sb.append(message);
        sb.append("\n");
        if (record.getThrown() != null) {
            sb.append(this.formatThrowable(record.getThrown()));
        }
        return sb.toString();
    }

    private Object formatStackTraceElement(StackTraceElement m) {
        return String.valueOf(m.getClassName()) + "." + m.getMethodName() + "(" + m.getFileName() + ":" + m.getLineNumber() + ")";
    }

    private String formatThrowable(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.format("Exce\u00e7\u00e3o: %s - %s%n", t.getClass().getName(), t.getMessage());
        this.printStack(t, pw);
        Throwable cause = t.getCause();
        while (cause != null) {
            this.printStack(cause, pw);
            pw.format("Causada por: %s - %s%n", cause.getClass().getName(), cause.getMessage());
            this.printStack(cause, pw);
            cause = cause.getCause();
        }
        pw.close();
        return sw.toString();
    }

    private void printStack(Throwable t, PrintWriter pw) {
        StackTraceElement[] stack = t.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            pw.print("  em ");
            pw.println(this.formatStackTraceElement(stack[i]));
            ++i;
        }
    }
}

