/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlatformIO {
    private static String FILENAME_PROPERTY = "PlatformIO.filename";
    private static String FILENAME;
    private static String fileName;
    private File dataFile;

    static {
        fileName = FILENAME = "platform.dat";
    }

    private synchronized void writeAll(Vector<Platform> platforms) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(fileName));
        try {
            for (Platform platform : platforms) {
                out.println(platform.getId() + "\t" + platform.getName() + "\t" + platform.getDescription());
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public synchronized List<Platform> readAll() throws IOException {
        Vector<Platform> allPlatforms = new Vector<Platform>();
        if (!this.dataFile.exists()) {
            return allPlatforms;
        }
        BufferedReader in = new BufferedReader(new FileReader(this.dataFile));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                try {
                    String id = st.nextToken();
                    String name = st.nextToken();
                    String desc = st.hasMoreTokens() ? st.nextToken() : "";
                    allPlatforms.add(new Platform((Object)new String(id), new PlatformInfo(name, desc)));
                }
                catch (NoSuchElementException nse) {
                    throw new IOException("Erro ao carregar a lista de plataformas: formato do arquivo inv\u00e1lido");
                }
            }
        }
        finally {
            in.close();
        }
        return allPlatforms;
    }

    public synchronized Platform read(Object id) throws IOException {
        try {
            for (Platform platform : Platform.getAllPlatforms()) {
                if (!platform.getId().equals(id)) continue;
                return platform;
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("Arquivo de plataformas corrompido");
        }
    }

    public synchronized Platform writeNew(PlatformInfo info) throws IOException {
        try {
            Vector<Platform> platforms = new Vector<Platform>(Platform.getAllPlatforms());
            String id = info.name;
            Platform platform = new Platform((Object)id, info);
            platforms.add(platform);
            this.writeAll(platforms);
            return platform;
        }
        catch (Exception e) {
            throw new IOException("Arquivo de plataformas corrompido");
        }
    }

    public synchronized Platform write(Object id, PlatformInfo info) throws IOException {
        try {
            Vector<Platform> platforms = new Vector<Platform>(Platform.getAllPlatforms());
            Platform platform = Platform.getPlatform((Object)id);
            if (!platforms.remove(platform)) {
                throw new IOException("A plataforma n\u00e3o existe");
            }
            platform = new Platform(id, info);
            platforms.add(platform);
            this.writeAll(platforms);
            return platform;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void delete(Object id) throws IOException {
        try {
            Platform platform = Platform.getPlatform((Object)id);
            Vector<Platform> platforms = new Vector<Platform>(Platform.getAllPlatforms());
            if (!platforms.remove(platform)) {
                throw new IOException("A plataforma n\u00e3o existe");
            }
            this.writeAll(platforms);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void printDataFile() throws IOException {
        try {
            PlatformIO pio = new PlatformIO();
            List<Platform> allPlatforms = pio.readAll();
            if (allPlatforms.size() == 0) {
                System.out.println("Arquivo de plataformas vazio");
            } else {
                for (Platform platform : allPlatforms) {
                    System.out.println(platform.getId() + ": <" + platform.getName() + " , " + platform.getDescription() + ">");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) throws IOException {
        PlatformIO.printDataFile();
    }

    public PlatformIO() {
        Server server = Server.getInstance();
        AdministrationService srv = AdministrationService.getInstance();
        fileName = String.valueOf(server.getPersistencyRootDirectoryName()) + File.separator + srv.getStringProperty(FILENAME_PROPERTY);
        this.dataFile = new File(fileName);
        Server.logInfoMessage("Arquivo de plataformas: " + fileName);
    }
}

