/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferProtocolStub;
import csbase.server.services.filetransferservice.sftp.SFTPDownloadJob;
import csbase.server.services.filetransferservice.sftp.SFTPUploadJob;
import csbase.server.services.filetransferservice.sftp.StubUserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SFTPStub
implements FileTransferProtocolStub {
    @Override
    public boolean checkConnection(FileTransferConnection connection) throws ServiceFailureException {
        Session session;
        String serverName = connection.getServerName();
        String userName = connection.getUserName();
        String password = connection.getPassword();
        JSch jsch = new JSch();
        int port = 22;
        try {
            session = jsch.getSession(userName, serverName, 22);
        }
        catch (JSchException e) {
            throw new ServiceFailureException(e.getMessage());
        }
        StubUserInfo ui = new StubUserInfo(password);
        session.setUserInfo((UserInfo)ui);
        try {
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public FileTransferJob createDownloadJob(FileTransferRequest request) throws ServiceFailureException {
        SFTPDownloadJob job = new SFTPDownloadJob(request);
        return job;
    }

    @Override
    public FileTransferJob createUploadJob(FileTransferRequest request) throws ServiceFailureException {
        SFTPUploadJob job = new SFTPUploadJob(request);
        return job;
    }

    @Override
    public List<FileTransferElement> listContent(FileTransferConnection connection, String remoteDirPath) throws ServiceFailureException {
        Session session;
        String serverName = connection.getServerName();
        String userName = connection.getUserName();
        String password = connection.getPassword();
        String rmtDirPath = remoteDirPath.trim();
        if (rmtDirPath.equals("")) {
            rmtDirPath = "/";
        }
        JSch jsch = new JSch();
        int port = 22;
        try {
            session = jsch.getSession(userName, serverName, 22);
        }
        catch (JSchException e) {
            throw new ServiceFailureException(e.getMessage());
        }
        ArrayList<FileTransferElement> elements = new ArrayList<FileTransferElement>();
        StubUserInfo ui = new StubUserInfo(password);
        session.setUserInfo((UserInfo)ui);
        try {
            session.connect();
            Channel c = session.openChannel("sftp");
            c.connect();
            ChannelSftp channel = (ChannelSftp)c;
            Vector ls = channel.ls(remoteDirPath);
            if (ls != null) {
                int i = 0;
                while (i < ls.size()) {
                    Object obj = ls.elementAt(i);
                    if (obj instanceof ChannelSftp.LsEntry) {
                        ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)obj;
                        String name = entry.getFilename();
                        SftpATTRS attrs = entry.getAttrs();
                        boolean isDir = attrs.isDir();
                        long size = attrs.getSize();
                        boolean isLink = attrs.isLink();
                        FileTransferElement elem = new FileTransferElement(name, isDir, size, isLink);
                        elements.add(elem);
                    }
                    ++i;
                }
            }
            return elements;
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.getMessage());
        }
    }
}

