/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.messageservice;

import csbase.server.Server;
import csbase.util.messages.MessageStore;
import csbase.util.messages.dao.IMessageStoreDAO;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class MessageStoreDAO
implements IMessageStoreDAO {
    private File backup;

    public MessageStoreDAO(File file) {
        this.backup = file;
    }

    /*
     * Loose catch block
     */
    public synchronized Collection<MessageStore> getAllMessageStores() {
        String backupFilePath = this.backup.getAbsolutePath();
        Server.logInfoMessage("Iniciando recupera\u00e7\u00e3o de backup de: " + backupFilePath);
        if (!this.backup.exists()) {
            String msg = "N\u00e3o foi encontrado arquivo de backup de mensagens: ";
            Server.logWarningMessage("N\u00e3o foi encontrado arquivo de backup de mensagens: " + backupFilePath);
            return Collections.emptyList();
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backup)));
            Collection stores = (Collection)in.readObject();
            Server.logInfoMessage("Mensagens recuperadas de: " + backupFilePath);
            Collection collection = stores;
            if (in != null) {
                this.closeCloseable(in);
            }
            return collection;
        }
        catch (InvalidClassException ce) {
            String err = "N\u00e3o foi poss\u00edvel fazer recupera\u00e7\u00e3o de backup. ";
            String cause = "Vers\u00e3o do t\u00f3pico n\u00e3o compat\u00edvel com arquivo: ";
            Server.logWarningMessage(String.valueOf(err) + cause + backupFilePath);
            if (in != null) {
                this.closeCloseable(in);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de recupera\u00e7\u00e3o de backup: " + backupFilePath, e);
            if (in != null) {
                this.closeCloseable(in);
            }
            {
                catch (Throwable throwable) {
                    if (in != null) {
                        this.closeCloseable(in);
                    }
                    throw throwable;
                }
            }
        }
        return Collections.emptyList();
    }

    public synchronized <T extends Collection<MessageStore> & Serializable> void saveAllMessageStores(T stores) {
        block6: {
            if (stores == null) {
                throw new NullPointerException("stores == null");
            }
            FileOutputStream fStream = null;
            ObjectOutputStream outStream = null;
            try {
                try {
                    fStream = new FileOutputStream(this.backup);
                    outStream = new ObjectOutputStream(fStream);
                    outStream.writeObject(stores);
                    outStream.flush();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Falha ao escrever no arquivo de backup: " + this.backup.getAbsolutePath(), e);
                    this.closeCloseable(outStream);
                    this.closeCloseable(fStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeCloseable(outStream);
                this.closeCloseable(fStream);
                throw throwable;
            }
            this.closeCloseable(outStream);
            this.closeCloseable(fStream);
        }
    }

    private void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                Server.logWarningMessage(e.getMessage());
            }
        }
    }
}

