/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_04;

import csbase.exception.ParseException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.opendreamsservice.opendreams.v1_04.AlgorithmTemplateException;
import csbase.server.services.projectservice.ProjectService;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.openbus.DRMAA.JobSubmissionState;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplate;

public class AlgorithmTemplate {
    @Option(name="-name")
    private String algoName;
    @Option(name="-version")
    private String algoVersion;
    private AlgorithmConfigurator configurator;
    private AlgorithmVersionId versionId;
    private CommonClientProject project;
    private String userId;
    private static String[] VALID_COMMANDS = new String[]{"execAlgo", "execFlow"};
    private static String[] VALID_JOB_CATEGORIES = new String[]{"CSBase", "System"};

    public AlgorithmTemplate(CommonClientProject project, String userId, OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        this.project = project;
        this.userId = userId;
        this.validateRemoteCommand(jt);
        this.validateArgs(jt);
        this.validateNumberOfProcesses(jt);
        this.validateJobParameters(jt);
        this.validateJobSubmissionState(jt);
        this.validateJobEnvironment(jt);
        this.validateWorkingDirectory(jt);
        this.validateJobCategory(jt);
        this.validateNativeSpecification(jt);
        this.validateEmail(jt);
        this.validateBlockEmail(jt);
        this.validateJobName(jt);
        this.validateInputPath(jt);
        this.validateOutputPath(jt);
        this.validateErrorPath(jt);
        this.validateJoinFiles(jt);
        this.validateTransferFiles(jt);
        this.validateHardWallClockTimeLimit(jt);
        this.validateSoftWallClockTimeLimit(jt);
        this.validateHardRunDurationLimit(jt);
        this.validateSoftRunDurationLimit(jt);
    }

    private void validateRemoteCommand(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        String[] stringArray = VALID_COMMANDS;
        int n = VALID_COMMANDS.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            if (jt.remoteCommand.equals(command)) {
                return;
            }
            ++n2;
        }
        throw new AlgorithmTemplateException("Falha na valida\u00e7\u00e3o de remoteCommand:" + jt.remoteCommand);
    }

    /*
     * Unable to fully structure code
     */
    private void validateArgs(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(jt.args);
            this.versionId = AlgorithmVersionId.create((String)this.algoVersion);
            this.configurator = AlgorithmService.getInstance().createAlgorithmConfigurator(this.getAlgoName(), this.getAlgoVersionId());
        }
        catch (CmdLineException e) {
            args = new StringBuffer();
            var8_6 = jt.args;
            var7_7 = jt.args.length;
            var6_8 = 0;
            ** while (var6_8 < var7_7)
        }
lbl-1000:
        // 1 sources

        {
            arg = var8_6[var6_8];
            args.append(arg);
            args.append(" ");
            ++var6_8;
            continue;
        }
lbl20:
        // 1 sources

        throw new AlgorithmTemplateException("Falha na valida\u00e7\u00e3o de args:" + args, e);
        catch (AlgorithmNotFoundException e) {
            throw new AlgorithmTemplateException("Algoritmo " + this.getAlgoName() + " vers\u00e3o " + this.getAlgoVersionId() + " n\u00e3o encontrados", e);
        }
    }

    private void validateJobParameters(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        String[][] stringArray = jt.jobParameters;
        int n = jt.jobParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parameter = stringArray[n2];
            String name = parameter[0];
            String value = parameter[1];
            try {
                this.configurator.setParameterValue(name, value);
            }
            catch (ParseException e) {
                throw new AlgorithmTemplateException("O par\u00e2metro " + name + " possui o valor com formato inv\u00e1lido: " + value, e);
            }
            catch (ParameterNotFoundException e) {
                throw new AlgorithmTemplateException("O par\u00e2metro " + name + " n\u00e3o existe na configura\u00e7\u00e3o do algoritmo", e);
            }
            ++n2;
        }
        try {
            ValidationContext context = new ValidationContext(ValidationMode.FULL, this.project.getId(), (Object)this.userId);
            Validation result = this.configurator.validate(context);
            if (!result.isWellSucceded()) {
                LocalizedMessage message = result.getMessage();
                throw new AlgorithmTemplateException("Valida\u00e7\u00e3o dos par\u00e2metros do algoritmo falhou: " + message);
            }
        }
        catch (RemoteException e) {
            throw new AlgorithmTemplateException("N\u00e3o foi poss\u00edvel validar os par\u00e2metros do algoritmo", e);
        }
    }

    private void validateJobSubmissionState(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (!jt.jobSubmissionState.equals(JobSubmissionState.ACTIVE_STATE)) {
            throw new AlgorithmTemplateException("O atributo jobSubmissionState deve ser ACTIVE_STATE");
        }
    }

    private void validateJobEnvironment(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.jobEnvironment.length != 0) {
            throw new AlgorithmTemplateException("O atributo jobEnvironment n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateWorkingDirectory(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.workingDirectory != null && !jt.workingDirectory.isEmpty()) {
            throw new AlgorithmTemplateException("O atributo workingDirectory n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateJobCategory(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.jobCategory != null && !Arrays.asList(VALID_JOB_CATEGORIES).contains(jt.jobCategory)) {
            throw new AlgorithmTemplateException("O atributo jobCategory deve ser CSBase ou System");
        }
        if (jt.jobCategory != null && jt.jobCategory.equals("System")) {
            throw new AlgorithmTemplateException("A categoria System ainda n\u00e3o est\u00e1 implementada no OpenDreams");
        }
    }

    private void validateNativeSpecification(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.nativeSpecification != null && !jt.nativeSpecification.isEmpty()) {
            throw new AlgorithmTemplateException("O atributo nativeSpecification n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateNumberOfProcesses(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.numberOfProcesses != 0) {
            throw new AlgorithmTemplateException("O atributo numberOfProcesses n\u00e3o \u00e9 implementado na vers\u00e3o atual do sistema CSBase");
        }
    }

    private void validateEmail(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
    }

    private void validateBlockEmail(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
    }

    private void validateJobName(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.jobName != null && !jt.jobName.isEmpty()) {
            throw new AlgorithmTemplateException("O atributo jobName n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateInputPath(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.inputPath != null && !jt.inputPath.isEmpty()) {
            throw new AlgorithmTemplateException("O atributo inputPath n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateOutputPath(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        String dirPath = FileUtils.getFilePath((String)jt.outputPath);
        String[] paths = FileUtils.splitPath((String)dirPath);
        if (paths.length > 0 && !ProjectService.getInstance().existsFile(this.project.getId(), paths)) {
            throw new AlgorithmTemplateException("O diret\u00f3rio " + dirPath + " n\u00e3o existe no projeto");
        }
    }

    private void validateErrorPath(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
    }

    private void validateJoinFiles(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
    }

    private void validateTransferFiles(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
    }

    private void validateHardWallClockTimeLimit(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.hardWallClockTimeLimit != 0L) {
            throw new AlgorithmTemplateException("O atributo hardWallClockTimeLimit n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateSoftWallClockTimeLimit(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.softWallClockTimeLimit != 0L) {
            throw new AlgorithmTemplateException("O atributo softWallclockTimeLimit n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateHardRunDurationLimit(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.hardRunDurationLimit != 0L) {
            throw new AlgorithmTemplateException("O atributo hardRunDurationLimit n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateSoftRunDurationLimit(OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        if (jt.softRunDurationLimit != 0L) {
            throw new AlgorithmTemplateException("O atributo softRunDurationLimit n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    public String getAlgoName() {
        return this.algoName;
    }

    public AlgorithmVersionId getAlgoVersionId() {
        return this.versionId;
    }

    public AlgorithmConfigurator getAlgorithmConfigurator() {
        return this.configurator;
    }
}

