/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.wioservice.WIOServerProject;
import csbase.server.services.wioservice.WIOService;
import csbase.server.services.wioservice.idl.BytesHolder;
import csbase.server.services.wioservice.idl.SeekType;
import csbase.server.services.wioservice.idl.WIODateTimeInfo;
import csbase.server.services.wioservice.idl.WIOFile;
import csbase.server.services.wioservice.idl.WIOFileHelper;
import csbase.server.services.wioservice.idl.WIOFileMode;
import csbase.server.services.wioservice.idl.WIOFilePOA;
import csbase.server.services.wioservice.idl.WIOProject;
import csbase.server.services.wioservice.idl.WIOProjectHelper;
import csbase.server.services.wioservice.idl.WIOServiceException;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import tecgraf.javautils.core.io.FileUtils;

public class WIOServerFile
extends WIOFilePOA {
    private File javaFile = null;
    private WIOServerProject wioServerProject = null;
    private String serverPath = null;
    private WIOFileMode fileMode = null;
    private RandomAccessFile randomFile = null;

    protected POA activateCorbaFile() throws Exception {
        WIOService wioService = WIOService.getInstance();
        return wioService.activateCorbaObject(null, (Servant)this);
    }

    public void appendDescription(String description) throws WIOServiceException {
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo em [" + this.toString() + "]");
        }
        try {
            this.wioServerProject.appendDescription(this.serverPath, description);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no appendDescription", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    private WIODateTimeInfo buildDateTime(long l) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(l);
        WIODateTimeInfo dateTime = new WIODateTimeInfo(cal.get(5), cal.get(2) + 1, cal.get(1), cal.get(11), cal.get(12), cal.get(13));
        return dateTime;
    }

    public boolean canRead() throws WIOServiceException {
        if (this.javaFile == null) {
            throw new WIOServiceException("Arquivo fisico nulo!");
        }
        return this.javaFile.canRead();
    }

    public boolean canWrite() throws WIOServiceException {
        if (this.javaFile == null) {
            throw new WIOServiceException("Arquivo fisico nulo!");
        }
        return this.javaFile.canWrite();
    }

    public void close() throws WIOServiceException {
        if (this.fileMode == WIOFileMode.NOT_OPENED) {
            Server.logSevereMessage("Duplo-close detectado: " + this.serverPath);
            return;
        }
        try {
            try {
                if (this.fileMode == WIOFileMode.MODE_WRITE) {
                    this.wioServerProject.setUnderConstruction(this.serverPath, false);
                }
                this.logInfo("Arquivo fechado: " + this.javaFile.getPath());
                this.logInfo("Agendando atualiza\u00e7\u00e3o do arquivo: " + this.javaFile.getPath());
                ProjectService projectService = ProjectService.getInstance();
                java.lang.Object loggedUserId = this.getMyUserId();
                if (loggedUserId == null) {
                    throw new Exception("Sem usuario ajustado para o close");
                }
                ProjectService.setUserId(loggedUserId);
                String uLogin = this.wioServerProject.getLoggedUserLogin();
                this.logInfo("Ativando atualiza\u00e7\u00e3o (close) pelo usu\u00e1rio " + uLogin);
                ClientProjectFile clientProjectFile = this.getClientProjectFile();
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha no close", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            this.fileMode = WIOFileMode.NOT_OPENED;
            FileUtils.close((Closeable)this.randomFile);
            this.randomFile = null;
            ProjectService.setUserId(null);
        }
    }

    public WIODateTimeInfo creationTime() throws WIOServiceException {
        try {
            ClientProjectFile cpf = this.getClientProjectFile();
            return this.buildDateTime(cpf.getCreationDate());
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no creationTime", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    protected void deactivateCorbaFile() throws Exception {
        WIOService wioService = WIOService.getInstance();
        wioService.deactivateCorbaObject((Servant)this);
    }

    public void destroy() throws WIOServiceException {
        try {
            try {
                this.deactivateCorbaFile();
                this.wioServerProject.decNumFiles();
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha no destroy", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            this.fileMode = WIOFileMode.NOT_OPENED;
            FileUtils.close((Closeable)this.randomFile);
            this.randomFile = null;
        }
    }

    public boolean eof() throws WIOServiceException {
        String myName = "[" + this.toString() + "]";
        if (this.fileMode == WIOFileMode.NOT_OPENED) {
            String err = "Falha de eof por arquivo fechado em " + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        if (this.randomFile == null) {
            String err = "Falha de eof por random-file nulo em " + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        try {
            return this.randomFile.getFilePointer() >= this.randomFile.length();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no eof", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    private ClientProjectFile getClientProjectFile() {
        ProjectService projectService = ProjectService.getInstance();
        java.lang.Object loggedUserId = this.getMyUserId();
        ProjectService.setUserId(loggedUserId);
        java.lang.Object projectId = this.getMyProjectId();
        String[] filePath = FileUtils.splitPath((String)this.serverPath);
        String[] dirPath = new String[filePath.length - 1];
        int i = 0;
        while (i < filePath.length - 1) {
            dirPath[i] = filePath[i];
            ++i;
        }
        String fileName = filePath[filePath.length - 1];
        ClientProjectFile child = projectService.getChild(projectId, dirPath, fileName);
        ProjectService.setUserId(null);
        return child;
    }

    public String getDescription() throws WIOServiceException {
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo em [" + this.toString() + "]");
        }
        try {
            String desc = this.wioServerProject.getDescription(this.serverPath);
            return desc.replaceAll("[^\\p{ASCII}]", "?");
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getDescription", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public WIOFile getFile(int i) throws WIOServiceException {
        if (this.serverPath == null) {
            throw new WIOServiceException("Path nulo detectado!");
        }
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo detectado!");
        }
        ClientProjectFile[] children = null;
        try {
            try {
                ProjectService projectService = ProjectService.getInstance();
                java.lang.Object loggedUserId = this.getMyUserId();
                ProjectService.setUserId(loggedUserId);
                java.lang.Object projectId = this.getMyProjectId();
                String[] filePath = FileUtils.splitPath((String)this.serverPath);
                children = projectService.getChildren(projectId, filePath, false);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha no getFile", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
        if (children == null) {
            throw new WIOServiceException("Array de filhos nulo detectado!");
        }
        if (i < 0 || i >= children.length) {
            throw new WIOServiceException("Indice invalido para array de filhos!");
        }
        String childPath = children[i].getStringPath();
        WIOFile corbaFile = null;
        try {
            WIOServerFile sonFile = new WIOServerFile(this.wioServerProject, childPath);
            POA poa = sonFile.activateCorbaFile();
            corbaFile = WIOFileHelper.narrow((Object)poa.servant_to_reference((Servant)sonFile));
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getFile(i)", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        if (corbaFile == null) {
            String msg = "Falha na aquisicao de arquivo-filho";
            throw new WIOServiceException("Falha na aquisicao de arquivo-filho");
        }
        return corbaFile;
    }

    public String getFileType() throws WIOServiceException {
        if (this.serverPath == null) {
            throw new WIOServiceException("Path nulo detectado!");
        }
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo detectado!");
        }
        try {
            ClientProjectFile cpf = this.getClientProjectFile();
            return cpf.getType();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getFileType", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    private int getMaxRead() {
        try {
            WIOService wioService = WIOService.getInstance();
            return wioService.getMaxReadKb() * 1024;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getMaxRead", e);
            return 0;
        }
    }

    private int getMaxWrite() {
        try {
            WIOService wioService = WIOService.getInstance();
            return wioService.getMaxWriteKb() * 1024;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getMaxWrite", e);
            return 0;
        }
    }

    public WIOFileMode getMode() throws WIOServiceException {
        if (this.javaFile == null) {
            throw new WIOServiceException("Arquivo fisico nulo!");
        }
        return this.fileMode;
    }

    private java.lang.Object getMyProjectId() {
        User oldUser = ProjectService.getUser();
        ProjectService projectService = ProjectService.getInstance();
        ProjectService.setUserId(User.getAdminId());
        String prjName = this.wioServerProject.getProjectName();
        java.lang.Object userId = this.getMyUserId();
        java.lang.Object pid = projectService.getProjectId(userId, prjName);
        if (oldUser != null) {
            ProjectService.setUserId(oldUser.getId());
        } else {
            ProjectService.setUserId(null);
        }
        return pid;
    }

    private java.lang.Object getMyUserId() {
        String uLogin = this.wioServerProject.getLoggedUserLogin();
        User loggedUser = null;
        try {
            loggedUser = User.getUserByLogin((String)uLogin);
        }
        catch (Exception e) {
            String fmt = "Falha na obtencao de usuario: %s";
            String err = String.format("Falha na obtencao de usuario: %s", uLogin);
            Server.logSevereMessage(err);
            loggedUser = null;
        }
        if (loggedUser == null) {
            String fmt = "Acesso a getProjectService com usuario invalido: %s";
            String err = String.format("Acesso a getProjectService com usuario invalido: %s", uLogin);
            Server.logSevereMessage(err);
            return null;
        }
        java.lang.Object loggedUserId = loggedUser.getId();
        return loggedUserId;
    }

    public int getNumFiles() throws WIOServiceException {
        if (this.serverPath == null) {
            throw new WIOServiceException("Path nulo detectado!");
        }
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo detectado!");
        }
        ClientProjectFile[] children = null;
        try {
            try {
                ProjectService projectService = ProjectService.getInstance();
                java.lang.Object loggedUserId = this.getMyUserId();
                ProjectService.setUserId(loggedUserId);
                java.lang.Object projectId = this.getMyProjectId();
                String[] filePath = FileUtils.splitPath((String)this.serverPath);
                children = projectService.getChildren(projectId, filePath, false);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha no getNumFiles()", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
        if (children == null) {
            throw new WIOServiceException("Array de filhos nulo detectado!");
        }
        return children.length;
    }

    public WIOFile getParent() throws WIOServiceException {
        String[] splitPath = FileUtils.splitPath((String)this.getPath());
        String parentPath = "";
        int limit = splitPath.length - 1;
        int i = 0;
        while (i < limit) {
            parentPath = String.valueOf(parentPath) + splitPath[i];
            if (i != limit - 1) {
                parentPath = String.valueOf(parentPath) + File.separator;
            }
            ++i;
        }
        WIOFile corbaFile = null;
        try {
            WIOServerFile parentFile = new WIOServerFile(this.wioServerProject, parentPath);
            POA poa = parentFile.activateCorbaFile();
            corbaFile = WIOFileHelper.narrow((Object)poa.servant_to_reference((Servant)parentFile));
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getParent", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        if (corbaFile == null) {
            String err = "Falha de narrow acesso : " + this.toString();
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        return corbaFile;
    }

    public String getPath() throws WIOServiceException {
        if (this.serverPath == null) {
            throw new WIOServiceException("Path nulo!");
        }
        return this.serverPath;
    }

    public WIOProject getProject() throws WIOServiceException {
        WIOProject corbaPrj = null;
        try {
            POA poa = this.activateCorbaFile();
            WIOServerProject wsp = this.wioServerProject;
            corbaPrj = WIOProjectHelper.narrow((Object)poa.servant_to_reference((Servant)wsp));
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no getProject", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        if (corbaPrj == null) {
            String err = "Falha de narrow de projeto : " + this.toString();
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        return corbaPrj;
    }

    public boolean isDirectory() throws WIOServiceException {
        if (this.javaFile == null) {
            throw new WIOServiceException("Arquivo fisico nulo!");
        }
        return this.javaFile.isDirectory();
    }

    public boolean isPublished() {
        return false;
    }

    public boolean isUnderConstruction() throws WIOServiceException {
        try {
            ClientProjectFile cpf = this.getClientProjectFile();
            return cpf.isUnderConstruction();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no isUnderConstrution", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public WIODateTimeInfo lastModificationTime() throws WIOServiceException {
        try {
            ClientProjectFile cpf = this.getClientProjectFile();
            return this.buildDateTime(cpf.getModificationDate());
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no lastModificationTime", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    private void logInfo(String msg) {
        try {
            WIOService wioService = WIOService.getInstance();
            if (wioService != null) {
                Server.logInfoMessage(msg);
            }
        }
        catch (Exception e) {
            System.out.println(msg);
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void open(WIOFileMode mode) throws WIOServiceException {
        if (this.fileMode != WIOFileMode.NOT_OPENED) {
            throw new WIOServiceException("Arquivo ja esta aberto.");
        }
        if (mode == WIOFileMode.NOT_OPENED) {
            throw new WIOServiceException("Modo invalido para abertura de arquivo.");
        }
        try {
            if (mode == WIOFileMode.MODE_READ) {
                this.fileMode = mode;
                this.randomFile = new RandomAccessFile(this.javaFile, "r");
                this.logInfo("Arquivo aberto para leitura: " + this.javaFile.getPath());
            } else if (mode == WIOFileMode.MODE_WRITE) {
                this.fileMode = mode;
                this.randomFile = new RandomAccessFile(this.javaFile, "rws");
                this.wioServerProject.setUnderConstruction(this.serverPath, true);
                this.logInfo("Arquivo aberto para escrita: " + this.javaFile.getPath());
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no open()", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public int read(int numBytes, BytesHolder holder) throws WIOServiceException {
        String myName = "[" + this.toString() + "]";
        int size = numBytes;
        if (this.fileMode != WIOFileMode.MODE_READ) {
            String err = "Leitura por arquivo fora do modo READ : " + myName;
            throw new WIOServiceException(err);
        }
        if (size <= 0) {
            String err = "Tamanho de READ negativo! : " + myName;
            throw new WIOServiceException(err);
        }
        if (this.randomFile == null) {
            String err = "Falha em READ por random-file nulo! : " + myName;
            throw new WIOServiceException(err);
        }
        if (size > this.getMaxRead()) {
            Server.logSevereMessage("Tamanho de READ fora do limite: " + myName + " - " + "truncando de " + size + " para " + this.getMaxRead());
            size = this.getMaxRead();
        }
        try {
            long pos = this.randomFile.getFilePointer();
            long len = this.randomFile.length();
            int nbytes = size;
            if (pos + (long)size > len) {
                nbytes = (int)(len - pos);
                this.logInfo("Tamanho de READ maior que resto do arquivo: " + myName + " - " + "truncando de " + size + " para " + nbytes + " " + "(cursor=" + pos + " tamanho=" + len + ")");
            }
            byte[] buffer = new byte[nbytes];
            this.randomFile.readFully(buffer);
            holder.value = buffer;
            return nbytes;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de read", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public void resize(long size) throws WIOServiceException {
        String myName = "[" + this.toString() + "]";
        if (this.randomFile == null) {
            String err = "Falha em READ por random-file nulo! : " + myName;
            throw new WIOServiceException(err);
        }
        try {
            this.randomFile.setLength(size);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de resize", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public void seek(long offset, SeekType type) throws WIOServiceException {
        String myName = "[" + this.toString() + "]";
        if (this.randomFile == null) {
            String err = "Falha de seek por random-file nulo em " + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        try {
            long position = 0L;
            if (type == SeekType.SEEK_TYPE_SET) {
                position = offset;
            } else if (type == SeekType.SEEK_TYPE_CUR) {
                long pos = this.randomFile.getFilePointer();
                position = pos + offset;
            } else if (type == SeekType.SEEK_TYPE_END) {
                long length = this.randomFile.length();
                position = length + offset;
            }
            this.randomFile.seek(position);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de seek", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public void setDescription(String desc) throws WIOServiceException {
        if (this.wioServerProject == null) {
            throw new WIOServiceException("Projeto nulo em [" + this.toString() + "]");
        }
        try {
            this.wioServerProject.setDescription(this.serverPath, desc);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de setDescription", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public long size() throws WIOServiceException {
        if (this.javaFile == null) {
            String myName = "[" + this.toString() + "]";
            String err = "Falha de size(). Arquivo fisico nao existe: ";
            err = String.valueOf(err) + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        if (this.isDirectory()) {
            String myName = "[" + this.toString() + "]";
            String err = "Falha de size(). Pedido sobre um diretorio: ";
            err = String.valueOf(err) + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        try {
            return this.javaFile.length();
        }
        catch (Exception e) {
            String err = e.getMessage();
            Server.logSevereMessage(err);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public long tell() throws WIOServiceException {
        if (this.randomFile == null) {
            String myName = "[" + this.toString() + "]";
            String err = "Falha de eof por random-file nulo em " + myName;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        try {
            return this.randomFile.getFilePointer();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de tell", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public String toString() {
        java.lang.Object uid = this.getMyUserId();
        java.lang.Object pid = this.getMyProjectId();
        String userText = "usu\u00e1rio nulo";
        if (uid != null) {
            userText = uid.toString();
        }
        String prjText = "projeto nulo";
        if (pid != null) {
            prjText = pid.toString();
        }
        return "[WIO File]: " + userText + "@" + prjText + ":" + this.serverPath;
    }

    public String whoCreated() throws WIOServiceException {
        java.lang.Object whoCreated;
        block3: {
            try {
                ClientProjectFile cpf = this.getClientProjectFile();
                whoCreated = cpf.whoCreated();
                if (whoCreated != null) break block3;
                return "???";
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha no m\u00e9todo whoCreated", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        return whoCreated.toString();
    }

    public int write(byte[] content) throws WIOServiceException {
        String myName = "[" + this.toString() + "]";
        if (this.fileMode != WIOFileMode.MODE_WRITE) {
            String err = "Leitura por arquivo fora do modo WRITE : " + myName;
            throw new WIOServiceException(err);
        }
        if (this.randomFile == null) {
            String err = "Falha em READ por random-file nulo! : " + myName;
            throw new WIOServiceException(err);
        }
        int size = content.length;
        if (size > this.getMaxWrite()) {
            String err = "Tamanho de WRITE fora do limite: " + myName + " - " + "truncando de " + size + " para " + this.getMaxWrite();
            Server.logSevereMessage(err);
            size = this.getMaxWrite();
        }
        try {
            this.randomFile.write(content, 0, size);
            return size;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de write", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    protected WIOServerFile(WIOServerProject serverProject, String serverPath) throws Exception {
        if (serverProject == null) {
            throw new Exception("Projeto/usuario nao identificado! ");
        }
        if (serverPath == null) {
            throw new Exception("Arquivo nao identificado!");
        }
        this.wioServerProject = serverProject;
        this.serverPath = serverPath;
        this.fileMode = WIOFileMode.NOT_OPENED;
        ProjectService projectService = ProjectService.getInstance();
        java.lang.Object loggedUserId = this.getMyUserId();
        ProjectService.setUserId(loggedUserId);
        java.lang.Object pid = this.getMyProjectId();
        String[] filePath = FileUtils.splitPath((String)this.serverPath);
        try {
            try {
                this.javaFile = projectService.getFile(pid, filePath);
            }
            catch (ServiceFailureException e) {
                String fmt = "Falha de arquivo WIO: projeto '%s' (%s) getFile(%s)";
                String prjName = serverProject.getProjectName();
                String err = String.format("Falha de arquivo WIO: projeto '%s' (%s) getFile(%s)", prjName, pid, this.serverPath);
                Server.logSevereMessage(err);
                throw new Exception(e);
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
        if (this.javaFile == null || !this.javaFile.exists()) {
            String path = this.javaFile.getAbsolutePath();
            String fmt = "Arquivo fisico nao existe no servidor: %s";
            String err = String.format("Arquivo fisico nao existe no servidor: %s", path);
            Server.logSevereMessage(err);
            throw new Exception(err);
        }
        serverProject.incNumFiles();
    }
}

