/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.xmlconversionservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.Utilities;
import csbase.remote.XMLConversionServiceInterface;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.xmlconversionservice.ServiceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Calendar;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.xml.conversion.XMLConverter;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;

public class XMLConversionService
extends Service
implements XMLConversionServiceInterface {
    public XMLConversionService() throws ServerException {
        super("XMLConversionService");
    }

    @Override
    public void initService() throws ServerException {
    }

    @Override
    public void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    public XMLConverter.XMLConversionStatus convertXMLToFile(Object projectId, String[] clientPath, boolean validate, String dtdPrefix) throws RemoteException {
        XMLConverter converter;
        OutputStream outputStream;
        String xmlData;
        XMLConverter.XMLConversionStatus status;
        ProjectService projectService;
        block8: {
            XMLConverter.XMLConversionStatus xMLConversionStatus;
            block9: {
                projectService = ProjectService.getInstance();
                status = null;
                xmlData = null;
                outputStream = null;
                converter = this.createConverter(dtdPrefix);
                xmlData = this.readXMLAsString(projectId, clientPath);
                this.preConvert(projectId, clientPath, dtdPrefix, xmlData);
                status = converter.convert(xmlData, validate).getConversionStatus();
                if (status != XMLConverter.XMLConversionStatus.NOT_NEEDED) break block8;
                this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                xMLConversionStatus = status;
                this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                if (outputStream == null) break block9;
                FileUtils.close((Closeable)outputStream);
            }
            return xMLConversionStatus;
        }
        try {
            try {
                outputStream = projectService.getOutputStream(projectId, clientPath);
                converter.saveTo(outputStream);
            }
            catch (XMLConversionException e) {
                throw new ServiceFailureException(e.toString(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ServiceFailureException(this.getString("XMLConversionService.error.io"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
            if (outputStream != null) {
                FileUtils.close(outputStream);
            }
            throw throwable;
        }
        this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
        if (outputStream != null) {
            FileUtils.close((Closeable)outputStream);
        }
        long date = Calendar.getInstance().getTimeInMillis();
        String text = MessageFormat.format(this.getString("XMLConversionService.success.msg"), Utilities.getFormattedDate((long)date), Service.getUser().getId());
        projectService.appendFileDescription(projectId, clientPath, text);
        return status;
    }

    protected XMLConverter createConverter(String dtdPrefix) throws XMLConversionException {
        return new XMLConverter(dtdPrefix);
    }

    protected void postConvert(Object projectId, String[] clientPath, String dtdPrefix, OutputStream outputStream, String xmlData, XMLConverter.XMLConversionStatus status) {
    }

    protected void preConvert(Object projectId, String[] clientPath, String dtdPrefix, String xmlData) {
    }

    private String readXMLAsString(Object projectId, String[] clientPath) throws IOException {
        InputStream inputStream = ProjectService.getInstance().getInputStream(projectId, clientPath);
        String xmlData = ServiceUtils.readXMLAsString(inputStream, this.getXMLEndMarker());
        return xmlData;
    }

    protected String getXMLEndMarker() {
        return null;
    }

    public String convertXMLToString(Object projectId, String[] clientPath, boolean validate, String dtdPrefix) throws RemoteException {
        try {
            XMLConverter converter = this.createConverter(dtdPrefix);
            String xmlData = this.readXMLAsString(projectId, clientPath);
            converter.convert(xmlData, validate);
            return converter.saveToString();
        }
        catch (XMLConversionException e) {
            throw new ServiceFailureException(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceFailureException(this.getString("XMLConversionService.error.io"), (Throwable)e);
        }
    }

    protected void append(File src, OutputStream outputStream) throws XMLConversionException {
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                reader = new BufferedReader(new FileReader(src));
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    writer.write(10);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                System.out.println("Erro: src: " + src.getAbsolutePath() + " - outputStream: " + outputStream.toString());
                e.printStackTrace();
                throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.WRITE);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            FileUtils.close(writer);
            throw throwable;
        }
        FileUtils.close((Closeable)reader);
        FileUtils.close((Closeable)writer);
    }

    public static XMLConversionService getInstance() {
        return (XMLConversionService)XMLConversionService.getInstance("XMLConversionService");
    }

    public static void createService() throws ServerException {
        new XMLConversionService();
    }
}

