/**
 * $Id: UpdateHandler.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.server.services.diagnosticservice.engine;

import csbase.logic.diagnosticservice.Status;
import csbase.server.services.diagnosticservice.monitors.ProactiveMonitor;

/**
 * Interface que define o responsvel por atualizar o estado de um recurso. O
 * {@link ProactiveMonitor} deve chamar o mtodo
 * {@link #updateStatus(Status status)} para fazer a atualizao de estado.
 * 
 * @author Tecgraf
 */
public interface UpdateHandler {
  /**
   * Callback para atualiza o estado de um monitor. Este metodo  chamado por
   * monitores do tipo {@link tecgraf.diagnostic.core.monitor.ProactiveMonitor}.
   * 
   * @param status o estado do recurso
   */
  public void updateStatus(Status status);
}
